#include "m_pd.h"
#include "math.h"
#include "def.h"

static t_class *jotac_GEM_kernel_class;

typedef struct _jotac_GEM_kernel {
    t_object  x_obj;
    t_outlet *to_gem; // outlet
    t_outlet *to_jotac; // outlet

    t_float projecteur[nb_max_circuit][13]; // list des projecteurs
    t_float effet[nb_max_circuit][12]; // list des projecteurs
    t_float data[nb_max_circuit][12]; // list des projecteurs
    t_float forme[nb_max_circuit][12]; // list des projecteurs
    t_float groupe[nb_max_circuit][31]; // list des projecteurs
    t_float texte[nb_max_circuit][201]; // list des projecteurs

    t_float valeur_circuit[nb_max_circuit];
    t_float valeur_effet[nb_max_circuit];
    t_float valeur_data[nb_max_circuit];
    t_float valeur_bus_lumiere[nb_max_circuit];
    t_float valeur_DMX[nb_max_DMX];
    
    t_int menu; // numero du menu actuel
    t_int screenX, screenY; // taille de la fenettre opengl
    t_float mouseX, mouseY, mouseXmenu, mouseXpdf; // position de la sourie par rapport au pdf et au menu
    t_int mouseclic, mousedrag; 
    t_int mouse_state; // etat du curseur affiché
    t_int mode;
    t_int mode_tmp[10];
    t_int mod_ctrl, mod_shift; // si les touches control ou shift sont apuiyé
    
    // variable pour le mode edition
    t_float color[3]; // couleur de l'outil pipette a coller ds les projecteurs
    t_int selected_groupe; // groupe actuel ou on ajoute des projecteurs
    
    // variable pour le mode memoire
    t_int ligne;
    t_int colone; // pos du controleur cliqué
    t_float aff_offset;
    
    // variable pour le mode DMX
    t_int num_DMX;
    
    // variable pour le mode jeu
    t_int BCF_projecteur[16][nb_max_circuit]; // list des proj associé aux fader de la bcf
    t_int BCF_effet[16][nb_max_circuit]; // list des proj associé aux fader de la bcf
    t_int BCF_data[16][nb_max_circuit]; // list des proj associé aux fader de la bcf
    t_int control;
    // TODO initialisation a -1
    t_float BCF[16]; // valeur des 16  faders
    // todo : init a 0
} t_jotac_GEM_kernel;

void drag_selected(t_jotac_GEM_kernel *x, t_float dX, t_float dY)
{
    int i;
    t_atom change_pdf[5];

    for(i=0;i<nb_max_circuit;i++)
    {
        if ((x->projecteur[i][1]!=0) & (x->projecteur[i][0]==1) )
        {
            // post("drag element %d, de %f, %f", i, dX,dY);
            SETSYMBOL(&change_pdf[0], gensym("projecteur"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("move"),4,change_pdf);
        }
        if ((x->effet[i][1]!=0) & (x->effet[i][0]==1))
        {
            // post("drag element %d, de %f, %f", i, dX,dY);
            SETSYMBOL(&change_pdf[0], gensym("effet"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("move"),4,change_pdf);
        }
        if ((x->data[i][1]!=0) & (x->data[i][0]==1))
        {
            // post("drag element %d, de %f, %f", i, dX,dY);
            SETSYMBOL(&change_pdf[0], gensym("data"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("move"),4,change_pdf);
        }
        if ((x->groupe[i][1]!=0) & (x->groupe[i][0]==1))
        {
            // post("drag element %d, de %f, %f", i, dX,dY);
            SETSYMBOL(&change_pdf[0], gensym("groupe"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("move"),4,change_pdf);
        }
        if ((x->forme[i][1]!=0) & (x->forme[i][0]==1))
        {
            // post("drag element %d, de %f, %f", i, dX,dY);
            SETSYMBOL(&change_pdf[0], gensym("forme"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("move"),4,change_pdf);
        }
        if ((x->texte[i][1]!=0) & (x->texte[i][0]==1))
        {
            // post("drag element %d, de %f, %f", i, dX,dY);
            SETSYMBOL(&change_pdf[0], gensym("texte"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("move"),4,change_pdf);
        }
    }
}

void drag_DMX(t_jotac_GEM_kernel *x, t_float dY)
{
    t_atom change_pdf[2];

    SETFLOAT(&change_pdf[0],x->num_DMX); 
    SETFLOAT(&change_pdf[1],dY); //posY
    outlet_anything(x->to_jotac,gensym("inc_DMX"),2,change_pdf);
}

void drag_all_DMX(t_jotac_GEM_kernel *x, t_float dY)
{
    t_atom change_pdf[2];
    int i;
    
    for(i=0;i<nb_max_DMX;i++)
    {
        SETFLOAT(&change_pdf[0],i); 
        SETFLOAT(&change_pdf[1],dY); //posY
        outlet_anything(x->to_jotac,gensym("inc_DMX"),2,change_pdf);   
    }
}

void rot_selected(t_jotac_GEM_kernel *x, t_float dX, t_float dY)
{
    int i;
    t_atom change_pdf[5];

    for(i=0;i<nb_max_circuit;i++)
    {
        if ((x->projecteur[i][1]!=0) & (x->projecteur[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("projecteur"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("rot"),4,change_pdf);
        }
        if ((x->forme[i][1]!=0) & (x->forme[i][0]==1))
        {
            // post("drag element %d, de %f, %f", i, dX,dY);
            SETSYMBOL(&change_pdf[0], gensym("forme"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("rot"),4,change_pdf);
        }
        if ((x->texte[i][1]!=0) & (x->texte[i][0]==1))
        {
            // post("drag element %d, de %f, %f", i, dX,dY);
            SETSYMBOL(&change_pdf[0], gensym("texte"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("rot"),4,change_pdf);
        }
    }
}

void scale_selected(t_jotac_GEM_kernel *x, t_float dX, t_float dY)
{
    int i;
    t_atom change_pdf[5];

    for(i=0;i<nb_max_circuit;i++)
    {
        if ((x->forme[i][1]!=0) & (x->forme[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("forme"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("scale"),4,change_pdf);
        }
       if ((x->texte[i][1]!=0) & (x->texte[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("texte"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("scale"),4,change_pdf);
        }
    }
}

void value_selected(t_jotac_GEM_kernel *x, t_float dX, t_float dY)
{ // menu jeu + mousedrag
    int i;
    t_atom change_pdf[5];

    for(i=0;i<nb_max_circuit;i++)
    {
        if ((x->projecteur[i][1]!=0) & (x->projecteur[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("projecteur"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("valeur"),4,change_pdf);
        }
        if ((x->effet[i][1]!=0) & (x->effet[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("effet"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("valeur"),4,change_pdf);
        }
        if ((x->data[i][1]!=0) & (x->data[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("data"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("valeur"),4,change_pdf);
        }
        if ((x->groupe[i][1]!=0) & (x->groupe[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("groupe"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("valeur"),4,change_pdf);
        }
    }
}

void number_selected(t_jotac_GEM_kernel *x, t_float dX, t_float dY)
{ // 
    int i;
    t_atom change_pdf[5];

    for(i=0;i<nb_max_circuit;i++)
    {
        if ((x->projecteur[i][1]!=0) & (x->projecteur[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("projecteur"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("number"),4,change_pdf);
        }
        if ((x->effet[i][1]!=0) & (x->effet[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("effet"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("number"),4,change_pdf);
        }
        if ((x->data[i][1]!=0) & (x->data[i][0]==1))
        {
            SETSYMBOL(&change_pdf[0], gensym("data"));
            SETFLOAT(&change_pdf[1],(float)i); // index
            SETFLOAT(&change_pdf[2],dX); // posX
            SETFLOAT(&change_pdf[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("number"),4,change_pdf);
        }
    }
}

void number_memoire(t_jotac_GEM_kernel *x, t_float dX, t_float dY)
{ // menu memoire
    t_atom element[5];

    // post("drag posX %d, colone %d, dY %f", x->colone, x->ligne, dY);
    switch (x->ligne)
    {
        case (2): // circuit
        {
            SETSYMBOL(&element[0], gensym("projecteur_nb"));
            SETFLOAT(&element[1],x->colone + (int)x->aff_offset); // index
            SETFLOAT(&element[2],dX); // posX
            SETFLOAT(&element[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("valeur"),4,element);
            break;
        }
        case (1): // effet
        {
            SETSYMBOL(&element[0], gensym("effet_nb"));
            SETFLOAT(&element[1],x->colone + (int)x->aff_offset); // index
            SETFLOAT(&element[2],dX); // posX
            SETFLOAT(&element[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("valeur"),4,element);
            break;
        }
        case (0): // data
        {
            SETSYMBOL(&element[0], gensym("data_nb"));
            SETFLOAT(&element[1],x->colone + (int)x->aff_offset); // index
            SETFLOAT(&element[2],dX); // posX
            SETFLOAT(&element[3],dY); //posY
            outlet_anything(x->to_jotac,gensym("valeur"),4,element);
            break;
        }
        case (3): // posX
        {
            x->aff_offset -= (dX/2)*32;
            x->aff_offset = fmin(x->aff_offset, 511);
            x->aff_offset = fmax(0,x->aff_offset);
            // post("offsetX = %d", (int)x->aff_offset);
            SETSYMBOL(&element[0], gensym("aff_offset"));
            SETFLOAT(&element[1],(int)x->aff_offset); 
            outlet_anything(x->to_gem,gensym("pdf_mem"),2,element);
            break;
        }
    }
    
}

void click_menu_edition(t_jotac_GEM_kernel *x)
{
    int colone = (int)(x->mouseXmenu*8);

    // post("click menu edition");
    if (fabs(x->mouseY - 0.7)< 0.05)
    {   // post("add_proj, % d", colone );
        x->mode = mode_edition_add;
        x->mode_tmp[0] = 0;
        x->mode_tmp[1] = colone;
    }
    else
    if (fabs(x->mouseY - 0.6)< 0.05)
    {   // post("add_effet");
        x->mode = mode_edition_add;
        x->mode_tmp[0] = 1;
        x->mode_tmp[1] = colone;
    }
    else
    if (fabs(x->mouseY - 0.5)< 0.05)
    {    // add groupe
        x->mode = mode_edition_add;
        x->mode_tmp[0] = 2;
        x->mode_tmp[1] = colone;
    }
    else
    if (fabs(x->mouseY - 0.4)< 0.05)
    {   // add data
        x->mode = mode_edition_add;
        x->mode_tmp[0] = 3;
        x->mode_tmp[1] = colone;
    }
    else
    if (fabs(x->mouseY - 0.3)< 0.05)
    {   // ad forme
        x->mode = mode_edition_add;
        x->mode_tmp[0] = 4;
        x->mode_tmp[1] = colone;
    }
    else
    if (fabs(x->mouseY - 0.2)< 0.05)
    {    // post("change_config");
        switch (colone)
        {
            case 0 :
            {
                x->mode = mode_edition_selection;
                break;
            }
            case 1 :
            {
                x->mode = mode_edition_move;
                break;
            }
            case 2 : 
            {
                x->mode = mode_edition_rotate;
                break;
            }
            case 3 : 
            {
                x->mode = mode_edition_scale;
                break;
            }
            case 4 : 
            {    
                x->mode = mode_edition_type;
                break;
            }
            case 5 : 
            {    
                x->mode = mode_edition_groupe;
                break;
            }
            case 6 : 
            {    
                x->mode = mode_edition_number;
                break;
            }
            case 7 : 
            {    
                x->mode = mode_edition_delete;
                break;
            }
        }
        
    }
    // TODO add texte
    if (fabs(x->mouseY - -0.2)< 0.32)
    {   t_float pos_colorX,pos_colorY, pos_colorR, pos_colorT;

        x->mode = mode_edition_color;

        pos_colorX = (x->mouseXmenu-0.5)*2;
        pos_colorY = (x->mouseY + 0.2) / 0.32;
        
        pos_colorR = sqrt(pos_colorX*pos_colorX+pos_colorY*pos_colorY);
        pos_colorT = atan2(pos_colorY,pos_colorX);
        
        x->color[0] = fmax(0,cos(pos_colorT      ));
        x->color[1] = fmax(0,cos(pos_colorT + 2.1));
        x->color[2] = fmax(0,cos(pos_colorT + 4.2));

        x->color[0] *= fmin(pos_colorR*3, 2);
        x->color[1] *= fmin(pos_colorR*3, 2);
        x->color[2] *= fmin(pos_colorR*3, 2);
        
        x->color[0] += fmax(pos_colorR*3 - 2, 0);
        x->color[1] += fmax(pos_colorR*3 - 2, 0);
        x->color[2] += fmax(pos_colorR*3 - 2, 0);
        
        x->color[0] = fmin(1,x->color[0]);
        x->color[1] = fmin(1,x->color[1]);
        x->color[2] = fmin(1,x->color[2]);
    }    
}

void click_pdf_edition(t_jotac_GEM_kernel *x)
{
    //post("click pdf edition");
    int i, tmp;
    t_atom add_valeur[200];
    if (x->mode == mode_edition_delete)
    {   // supression de l'element cliqué
        for(i=0;i<nb_max_circuit;i++)
        { 
            if(((x->projecteur[i][1])!=0)&(fabs(x->projecteur[i][3] - x->mouseX)<0.05)&(fabs(x->projecteur[i][4] - x->mouseY)<0.05))
            { // projecteur
                SETSYMBOL(&add_valeur[0],gensym("projecteur"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("del"),2,add_valeur);
            }
            if(((x->effet[i][1])!=0)&(fabs(x->effet[i][3] - x->mouseX)<0.05)&(fabs(x->effet[i][4] - x->mouseY)<0.05))
            { // effet
                SETSYMBOL(&add_valeur[0],gensym("effet"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("del"),2,add_valeur);
            }
            if(((x->groupe[i][1])!=0)&(fabs(x->groupe[i][3] - x->mouseX)<0.05)&(fabs(x->groupe[i][4] - x->mouseY)<0.05))
            { // groupe
                SETSYMBOL(&add_valeur[0],gensym("groupe"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("del"),2,add_valeur);
            }            
            if(((x->data[i][1])!=0)&(fabs(x->data[i][3] - x->mouseX)<0.05)&(fabs(x->data[i][4] - x->mouseY)<0.05))
            { // data
                SETSYMBOL(&add_valeur[0],gensym("data"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("del"),2,add_valeur);
            }            
            if(((x->forme[i][1])!=0)&(fabs(x->forme[i][3] - x->mouseX)<0.05)&(fabs(x->forme[i][4] - x->mouseY)<0.05))
            { // forme
                SETSYMBOL(&add_valeur[0],gensym("forme"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("del"),2,add_valeur);
            }            
            if(((x->texte[i][1])!=0)&(fabs(x->texte[i][3] - x->mouseX)<0.05)&(fabs(x->texte[i][4] - x->mouseY)<0.05))
            { // text
                SETSYMBOL(&add_valeur[0],gensym("texte"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("del"),2,add_valeur);
            }
        } 
    }
 
    if (x->mode == mode_edition_add)
    {   // ajout d'un element
        switch (x->mode_tmp[0])
        {
        case 0:
                SETSYMBOL(&add_valeur[0],gensym("projecteur"));  
                break;    
        case 1:
                SETSYMBOL(&add_valeur[0],gensym("effet"));
                break;
        case 2:
                SETSYMBOL(&add_valeur[0],gensym("groupe"));
                break;
        case 3:
                SETSYMBOL(&add_valeur[0],gensym("data"));
                break;
        case 4:
                SETSYMBOL(&add_valeur[0],gensym("forme"));
                break;
        }
        SETFLOAT(&add_valeur[1],1); // type
        SETFLOAT(&add_valeur[2],x->mode_tmp[1]); // type
        SETFLOAT(&add_valeur[3],x->mouseX); // posX
        SETFLOAT(&add_valeur[4],x->mouseY); //posY
        SETFLOAT(&add_valeur[5],1); //R
        SETFLOAT(&add_valeur[6],1); //G
        SETFLOAT(&add_valeur[7],1); //B
        SETFLOAT(&add_valeur[8],1); //A
        SETFLOAT(&add_valeur[9],0); //Rot Z
        SETFLOAT(&add_valeur[10],1); //Sx
        SETFLOAT(&add_valeur[11],1); //Sy
        
        tmp = 12;
        if (x->mode_tmp[0] == 2)
        { // groupe
            SETFLOAT(&add_valeur[12],0); //nb data
            tmp = 13;
        }
        if (x->mode_tmp[0] == 4) // forme
            SETFLOAT(&add_valeur[8],0.5); //A
        outlet_anything(x->to_jotac,gensym("add"),tmp,add_valeur);
    }
    
    if (x->mode == mode_edition_type)
    {   // change le type d'un element
        for(i=0;i<nb_max_circuit;i++)
        {
            if( (((int)x->projecteur[i][1])!=0) & (fabs(x->projecteur[i][3] - x->mouseX)<0.05) & (fabs(x->projecteur[i][4] - x->mouseY)<0.05) )
            {
                SETSYMBOL(&add_valeur[0],gensym("projecteur"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                SETFLOAT(&add_valeur[2],(((int)x->projecteur[i][2]+1)%8)); 
                outlet_anything(x->to_jotac,gensym("type"),3,add_valeur);
            }
            if( (((int)x->effet[i][1])!=0) & (fabs(x->effet[i][3] - x->mouseX)<0.05) & (fabs(x->effet[i][4] - x->mouseY)<0.05) )
            {
                SETSYMBOL(&add_valeur[0],gensym("effet"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                SETFLOAT(&add_valeur[2],(((int)x->effet[i][2]+1)%6)); // type
                outlet_anything(x->to_jotac,gensym("type"),3,add_valeur);
            }
            if( (((int)x->data[i][1])!=0) & (fabs(x->data[i][3] - x->mouseX)<0.05) & (fabs(x->data[i][4] - x->mouseY)<0.05) )
            {
                SETSYMBOL(&add_valeur[0],gensym("data"));  
                SETFLOAT(&add_valeur[1],(float)i);
                SETFLOAT(&add_valeur[2],(((int)x->data[i][2]+1)%6)); // type
                outlet_anything(x->to_jotac,gensym("type"),3,add_valeur);
            }
            if( (((int)x->groupe[i][1])!=0) & (fabs(x->groupe[i][3] - x->mouseX)<0.05) & (fabs(x->groupe[i][4] - x->mouseY)<0.05) )
            {
                SETSYMBOL(&add_valeur[0],gensym("groupe"));  
                SETFLOAT(&add_valeur[1],(float)i);
                SETFLOAT(&add_valeur[2],(((int)x->groupe[i][2]+1)%6)); // type
                outlet_anything(x->to_jotac,gensym("type"),3,add_valeur);
            }
            if( (((int)x->forme[i][1])!=0) & (fabs(x->forme[i][3] - x->mouseX)<0.05) & (fabs(x->forme[i][4] - x->mouseY)<0.05) )
            {
                SETSYMBOL(&add_valeur[0],gensym("forme"));  
                SETFLOAT(&add_valeur[1],(float)i);
                SETFLOAT(&add_valeur[2],(((int)x->forme[i][2]+1)%6)); // type
                outlet_anything(x->to_jotac,gensym("type"),3,add_valeur);
            }            
        }
    }
    
    if (x->mode == mode_edition_color)
    {
        SETFLOAT(&add_valeur[2],x->color[0]); 
        SETFLOAT(&add_valeur[3],x->color[1]); 
        SETFLOAT(&add_valeur[4],x->color[2]); 

        for(i=0;i<nb_max_circuit;i++)
        { 
            if(((x->projecteur[i][1])!=0)&(fabs(x->projecteur[i][3] - x->mouseX)<0.05)&(fabs(x->projecteur[i][4] - x->mouseY)<0.05))
            { // projecteur
                SETSYMBOL(&add_valeur[0],gensym("projecteur"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("color"),5,add_valeur);
            }
            if(((x->effet[i][1])!=0)&(fabs(x->effet[i][3] - x->mouseX)<0.05)&(fabs(x->effet[i][4] - x->mouseY)<0.05))
            { // effet
                SETSYMBOL(&add_valeur[0],gensym("effet"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("color"),5,add_valeur);
            }
            if(((x->groupe[i][1])!=0)&(fabs(x->groupe[i][3] - x->mouseX)<0.05)&(fabs(x->groupe[i][4] - x->mouseY)<0.05))
            { // groupe
                SETSYMBOL(&add_valeur[0],gensym("groupe"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("color"),5,add_valeur);
            }            
            if(((x->data[i][1])!=0)&(fabs(x->data[i][3] - x->mouseX)<0.05)&(fabs(x->data[i][4] - x->mouseY)<0.05))
            { // data
                SETSYMBOL(&add_valeur[0],gensym("data"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("color"),5,add_valeur);
            }            
            if(((x->forme[i][1])!=0)&(fabs(x->forme[i][3] - x->mouseX)<0.05)&(fabs(x->forme[i][4] - x->mouseY)<0.05))
            { // forme
                SETSYMBOL(&add_valeur[0],gensym("forme"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("color"),5,add_valeur);
            }            
            if(((x->texte[i][1])!=0)&(fabs(x->texte[i][3] - x->mouseX)<0.05)&(fabs(x->texte[i][4] - x->mouseY)<0.05))
            { // text
                SETSYMBOL(&add_valeur[0],gensym("texte"));  
                SETFLOAT(&add_valeur[1],(float)i); 
                outlet_anything(x->to_jotac,gensym("color"),5,add_valeur);
            }
        } 
    }

    if (x->mod_ctrl==0)
    {
        //si mode normal, on deselectionne tout et selectionne l'element cliqué
        for(i=0;i<nb_max_circuit;i++)
        {
            if (x->projecteur[i][1]!=0)
            {
                x->projecteur[i][0]=0; // deselectionne
                if ((fabs(x->projecteur[i][3] - x->mouseX)<0.05)&(fabs(x->projecteur[i][4] - x->mouseY)<0.05))
                x->projecteur[i][0]=1; // selectionne
            }               
            if (x->effet[i][1]!=0)
            {
                x->effet[i][0]=0 ;// deselectionne
                if ((fabs(x->effet[i][3] - x->mouseX)<0.05)&(fabs(x->effet[i][4] - x->mouseY)<0.05))
                x->effet[i][0]=1 ;// selectionne
            }  
            if (x->data[i][1]!=0)
            {
                x->data[i][0]=0 ;// deselectionne
                if ((fabs(x->data[i][3] - x->mouseX)<0.05)&(fabs(x->data[i][4] - x->mouseY)<0.05))
                x->data[i][0]=1 ;// selectionne
            }  
            if (x->groupe[i][1]!=0)
            {
                x->groupe[i][0]=0 ;// deselectionne
                if ((fabs(x->groupe[i][3] - x->mouseX)<0.05)&(fabs(x->groupe[i][4] - x->mouseY)<0.05))
                x->groupe[i][0]=1 ;// selectionne
            }  
            if (x->forme[i][1]!=0)
            {
                x->forme[i][0]=0 ;// deselectionne
                if ((fabs(x->forme[i][3] - x->mouseX)<0.05)&(fabs(x->forme[i][4] - x->mouseY)<0.05))
                x->forme[i][0]=1 ;// selectionne
            }  
            if (x->texte[i][1]!=0)
            {
                x->texte[i][0]=0 ;// deselectionne
                if ((fabs(x->texte[i][3] - x->mouseX)<0.05)&(fabs(x->texte[i][4] - x->mouseY)<0.05))
                x->texte[i][0]=1 ;// selectionne
            }  
        }            
    }
    
    if (x->mod_ctrl==1)
    {
        // si la touche control est apuiyé: on togle la selection des elements clické
        for(i=0;i<nb_max_circuit;i++)
        {
            if ((x->projecteur[i][1]!=0)&(fabs(x->projecteur[i][3] - x->mouseX)<0.05)&(fabs(x->projecteur[i][4] - x->mouseY)<0.05))
                x->projecteur[i][0] = (int)x->projecteur[i][0] ^ 1;
            if ((x->effet[i][1]!=0)&(fabs(x->effet[i][3] - x->mouseX)<0.05)&(fabs(x->effet[i][4] - x->mouseY)<0.05))
                x->effet[i][0] = (int)x->effet[i][0] ^ 1;
            if ((x->data[i][1]!=0)&(fabs(x->data[i][3] - x->mouseX)<0.05)&(fabs(x->data[i][4] - x->mouseY)<0.05))
                x->data[i][0] = (int)x->data[i][0] ^ 1;
            if ((x->forme[i][1]!=0)&(fabs(x->forme[i][3] - x->mouseX)<0.05)&(fabs(x->forme[i][4] - x->mouseY)<0.05))
                x->forme[i][0] = (int)x->forme[i][0] ^ 1;
            if ((x->groupe[i][1]!=0)&(fabs(x->groupe[i][3] - x->mouseX)<0.05)&(fabs(x->groupe[i][4] - x->mouseY)<0.05))
                x->groupe[i][0] = (int)x->groupe[i][0] ^ 1;
            if ((x->texte[i][1]!=0)&(fabs(x->texte[i][3] - x->mouseX)<0.05)&(fabs(x->texte[i][4] - x->mouseY)<0.05))
                x->texte[i][0] = (int)x->texte[i][0] ^ 1;
        } 
    }
    // TODO : un rectangle de selection avec la touche shift
    
    if (x->mode == mode_edition_groupe)
    { //mode groupe un peu diferent : on deselctione tout et selectionne le groupe selectionné si il y en a 1
        for(i=0;i<nb_max_circuit;i++)
        {
            if (x->projecteur[i][1]!=0)
            {
                x->projecteur[i][0]=0; // deselectionne
                if ((fabs(x->projecteur[i][3] - x->mouseX)<0.05)&(fabs(x->projecteur[i][4] - x->mouseY)<0.05))
                {
                    // post("add proj %d au groupe %d", i, x->selected_groupe);
                    SETSYMBOL(&add_valeur[0],gensym("groupe"));  
                    SETFLOAT(&add_valeur[1],x->selected_groupe); 
                    SETFLOAT(&add_valeur[2],i); 
                    outlet_anything(x->to_jotac,gensym("toggle_projecteur"),3,add_valeur);
                }
            } 
            if (x->effet[i][1]!=0)
            {   x->effet[i][0]=0 ; } // deselectionne
            if (x->data[i][1]!=0)
            {   x->data[i][0]=0 ; } // deselectionne 
            if (x->forme[i][1]!=0)
            {   x->forme[i][0]=0 ;} // deselectionne 
            if (x->texte[i][1]!=0)
            {   x->texte[i][0]=0 ;} // deselectionne  
            if (x->groupe[i][1]!=0)
            {
                x->groupe[i][0]=0 ;// deselectionne
                if ((fabs(x->groupe[i][3] - x->mouseX)<0.05)&(fabs(x->groupe[i][4] - x->mouseY)<0.05))
                    x->selected_groupe = i;
            }  
        }
        if (x->selected_groupe>=0)
            x->groupe[x->selected_groupe][0]= 1; // selectionne le groupe predement selectionné
    }
}

void click_pdf_memoire(t_jotac_GEM_kernel *x)
{
    x->colone = (int)(x->mouseXpdf*33);
    x->colone = (int)fmax(x->colone, 0);
    x->ligne  = (int)(((x->mouseY+1)/2)*3.1);
}

void click_menu_jeu(t_jotac_GEM_kernel *x)
{
    int colone = (int)(x->mouseXmenu*8);
    x->mode = -1;
    if (fabs(x->mouseY - 0)< 0.25)
    {   
        // post("drag1, % d", colone );
        x->mode = mode_jeu_drag_BCF;
        x->mode_tmp[0] = colone;
    }
    if (fabs(x->mouseY - 0.6)< 0.15)
    {   
        // post("drag2, % d", colone );
        x->mode = mode_jeu_drag_BCF;
        x->mode_tmp[0] = colone+8;
    }
    if (fabs(x->mouseY - 0.4)< 0.04)
    {   
        // post("set2, % d", colone );
        x->mode = mode_jeu_set;
        x->mode_tmp[0] = colone+8;
    }
    if (fabs(x->mouseY + 0.3)< 0.04)
    {   
        // post("set1, % d", colone );
        x->mode = mode_jeu_set;
        x->mode_tmp[0] = colone;
    }
    
}

void click_pdf_jeu(t_jotac_GEM_kernel *x)
{
    //post("click pdf jeu");
    int i, j, tmp, clique;
    t_atom element[5];

    if((x->mode == mode_jeu_drag)|(x->mode == mode_jeu_drag_BCF))
    {
        x->mode = mode_jeu_drag;
        if (x->mod_ctrl==0)
        {
            //si mode normal, on deselectionne tout et selectionne l'element cliqué
            for(i=0;i<nb_max_circuit;i++)
            {
                if (x->projecteur[i][1]!=0)
                {
                    x->projecteur[i][0]=0; // deselectionne
                    if ((fabs(x->projecteur[i][3] - x->mouseX)<0.05)&(fabs(x->projecteur[i][4] - x->mouseY)<0.05))
                        x->projecteur[i][0]=1; // selectionne
                }               
                if (x->effet[i][1]!=0)
                {
                    x->effet[i][0]=0 ;// deselectionne
                    if ((fabs(x->effet[i][3] - x->mouseX)<0.05)&(fabs(x->effet[i][4] - x->mouseY)<0.05))
                        x->effet[i][0]=1 ;// selectionne
                }  
                if (x->data[i][1]!=0)
                {
                    x->data[i][0]=0 ;// deselectionne
                    if ((fabs(x->data[i][3] - x->mouseX)<0.05)&(fabs(x->data[i][4] - x->mouseY)<0.05))
                        x->data[i][0]=1 ;// selectionne
                }  
                // if (x->forme[i][1]!=0)
                x->forme[i][0]=0 ;// deselectionne

                // if (x->texte[i][1]!=0)
                x->texte[i][0]=0 ;// deselectionne
            }
            for(i=0;i<nb_max_circuit;i++)
            {        
                if (x->groupe[i][1]!=0)
                {
                    x->groupe[i][0]=0 ;// deselectionne
                    if ((fabs(x->groupe[i][3] - x->mouseX)<0.05)&(fabs(x->groupe[i][4] - x->mouseY)<0.05))
                    { // on selectionne pas le groupe, mais les proj du groupe
                        tmp = x->groupe[i][12]; // nb de proj ds le groupe
                        for (j=0;  j<tmp;j++)
                            x->projecteur[(int)x->groupe[i][13+j]][0]=1;
                    }
                }  
            }            
        }
        
        if (x->mod_ctrl==1)
        {
            // si la touche control est apuiyé: on togle la selection des elements clické
            for(i=0;i<nb_max_circuit;i++)
            {
                if ((x->projecteur[i][1]!=0)&(fabs(x->projecteur[i][3] - x->mouseX)<0.05)&(fabs(x->projecteur[i][4] - x->mouseY)<0.05))
                    x->projecteur[i][0] = (int)x->projecteur[i][0] ^ 1;
                if ((x->effet[i][1]!=0)&(fabs(x->effet[i][3] - x->mouseX)<0.05)&(fabs(x->effet[i][4] - x->mouseY)<0.05))
                    x->effet[i][0] = (int)x->effet[i][0] ^ 1;
                if ((x->data[i][1]!=0)&(fabs(x->data[i][3] - x->mouseX)<0.05)&(fabs(x->data[i][4] - x->mouseY)<0.05))
                    x->data[i][0] = (int)x->data[i][0] ^ 1;
                if ((x->forme[i][1]!=0)&(fabs(x->forme[i][3] - x->mouseX)<0.05)&(fabs(x->forme[i][4] - x->mouseY)<0.05))
                    x->forme[i][0] = (int)x->forme[i][0] ^ 1;
                if ((x->groupe[i][1]!=0)&(fabs(x->groupe[i][3] - x->mouseX)<0.05)&(fabs(x->groupe[i][4] - x->mouseY)<0.05))
                { 
                    // x->groupe[i][0] = (int)x->groupe[i][0] ^ 1;
                    tmp = x->groupe[i][12]; // nb de proj ds le groupe
                    for (j=0;  j<tmp;j++)
                        x->projecteur[(int)x->groupe[i][13+j]][0]=1;
                }    
                if ((x->texte[i][1]!=0)&(fabs(x->texte[i][3] - x->mouseX)<0.05)&(fabs(x->texte[i][4] - x->mouseY)<0.05))
                    x->texte[i][0] = (int)x->texte[i][0] ^ 1;
            } 
        }
        // TODO : un rectangle de selection avec la touche shift
    }
    else
    if(x->mode == mode_jeu_set)
    { // ajoute ou enleve des elements controlé par les faders
        if (0) //((x->mod_ctrl==0)&(x->control==0))
        {// TODO : en mode contol, on sort
            /*
            // pas de mode controle
            // clear tout les elements controlé par ce fader ssi on clique sur au moins un element...
            // TODO : ssi on clique sur au moins un element...
            for (i=0;i<nb_max_circuit;i++)
            {
                x->BCF_projecteur[x->mode_tmp[0]][i]=0;
                x->BCF_effet[x->mode_tmp[0]][i]=0;
                x->BCF_data[x->mode_tmp[0]][i]=0;                
            }
            clique = 0;
            for(i=0;i<nb_max_circuit;i++)
            {   // si on clique sur un element, on l'ajoute au control du fader et increment element_cliqué

                if ((x->projecteur[i][1]!=0)&(clique==0))
                {
                    if ((fabs(x->projecteur[i][3] - x->mouseX)<0.05)&(fabs(x->projecteur[i][4] - x->mouseY)<0.05))
                    {
                        x->BCF_projecteur[x->mode_tmp[0]][i] = 1;
                        clique++;
                        // actualise la BCF avec un envoie midi
                        SETFLOAT(&element[0],x->mode_tmp[0]); //num_fader
                        SETFLOAT(&element[1],x->valeur_circuit[(int)x->projecteur[i][1]-1]); //valeur
                        outlet_anything(x->to_gem,gensym("to_BCF"),2,element);
                        // actualise l'affichage de la bcf
                        x->BCF[x->mode_tmp[0]] = x->valeur_circuit[(int)x->projecteur[i][1]-1];
                    }
                }               
                if ((x->effet[i][1]!=0)&(clique==0))
                {
                    if ((fabs(x->effet[i][3] - x->mouseX)<0.05)&(fabs(x->effet[i][4] - x->mouseY)<0.05))
                    {
                        x->BCF_effet[x->mode_tmp[0]][i] = 1;
                        clique++;
                        // actualise la BCF avec un envoie midi
                        SETFLOAT(&element[0],x->mode_tmp[0]); //num_fader
                        SETFLOAT(&element[1],x->valeur_effet[(int)x->effet[i][1]-1]); //valeur
                        outlet_anything(x->to_gem,gensym("to_BCF"),2,element);
                        // actualise l'affichage de la bcf
                        x->BCF[x->mode_tmp[0]] = x->valeur_effet[(int)x->effet[i][1]-1];
                    }
                }  
                if ((x->data[i][1]!=0)&(clique==0))
                {
                    if ((fabs(x->data[i][3] - x->mouseX)<0.05)&(fabs(x->data[i][4] - x->mouseY)<0.05))
                    {
                        x->BCF_data[x->mode_tmp[0]][i] = 1;
                        clique++;
                        // actualise la BCF avec un envoie midi
                        SETFLOAT(&element[0],x->mode_tmp[0]); //num_fader
                        SETFLOAT(&element[1],x->valeur_data[(int)x->data[i][1]-1]); //valeur
                        outlet_anything(x->to_gem,gensym("to_BCF"),2,element);
                        // actualise l'affichage de la bcf
                        x->BCF[x->mode_tmp[0]] = x->valeur_data[(int)x->data[i][1]-1];
                    }
                } 
            }
            // si element_clique == 1, on passe au fader suivant, sinon on sort
            if (clique != 0)
                x->mode_tmp[0]++;
            if ((x->mode_tmp[0] == 8)|(x->mode_tmp[0] == 16)|(clique==0))
                x->mode=mode_jeu_drag;
        */
        }
        else
        { // mode control
        // TODO : si on bonge la bcf, alors on sort du mode set_jeu...
            clique = 0;
            // x->control=1; TODO : a virer partout, et voir si virer la variable "click"
            for(i=0;i<nb_max_circuit;i++)
            { // si on clique sur un element, alors toggle l'element ds la selection
                if (x->projecteur[i][1]!=0)
                {
                    if ((fabs(x->projecteur[i][3] - x->mouseX)<0.05)&(fabs(x->projecteur[i][4] - x->mouseY)<0.05))
                    {
                        if(x->BCF_projecteur[x->mode_tmp[0]][i] > 0)
                            x->BCF_projecteur[x->mode_tmp[0]][i] = 0;
                        else
                            x->BCF_projecteur[x->mode_tmp[0]][i] = 1;
                        // post("proj %d = %d",i,x->BCF_projecteur[x->mode_tmp[0]][i]);
                        clique++;
                        if (x->BCF_projecteur[x->mode_tmp[0]][i] == 1)
                        {
                            // actualise la BCF avec un envoie midi
                            SETFLOAT(&element[0],x->mode_tmp[0]); //num_fader
                            SETFLOAT(&element[1],x->valeur_circuit[(int)x->projecteur[i][1]-1]); //valeur
                            outlet_anything(x->to_gem,gensym("to_BCF"),2,element);
                            // actualise l'affichage de la bcf
                            x->BCF[x->mode_tmp[0]] = x->valeur_circuit[(int)x->projecteur[i][1]-1];
                        }
                    }
                }               
                if (x->effet[i][1]!=0)
                {
                    if ((fabs(x->effet[i][3] - x->mouseX)<0.05)&(fabs(x->effet[i][4] - x->mouseY)<0.05))
                    {
                        if(x->BCF_effet[x->mode_tmp[0]][i] > 0)
                            x->BCF_effet[x->mode_tmp[0]][i] = 0;
                        else
                            x->BCF_effet[x->mode_tmp[0]][i] = 1;
                        // post("proj %d = %d",i,x->BCF_projecteur[x->mode_tmp[0]][i]);
                        clique++;
                        if (x->BCF_effet[x->mode_tmp[0]][i] == 1)
                        {
                            // actualise la BCF avec un envoie midi
                            SETFLOAT(&element[0],x->mode_tmp[0]); //num_fader
                            SETFLOAT(&element[1],x->valeur_effet[(int)x->effet[i][1]-1]); //valeur
                            outlet_anything(x->to_gem,gensym("to_BCF"),2,element);
                            // actualise l'affichage de la bcf
                            x->BCF[x->mode_tmp[0]] = x->valeur_effet[(int)x->effet[i][1]-1];
                        }
                    }
                }  
                if (x->data[i][1]!=0)
                {
                    if ((fabs(x->data[i][3] - x->mouseX)<0.05)&(fabs(x->data[i][4] - x->mouseY)<0.05))
                    {
                        if(x->BCF_data[x->mode_tmp[0]][i] > 0)
                            x->BCF_data[x->mode_tmp[0]][i] = 0;
                        else
                            x->BCF_data[x->mode_tmp[0]][i] = 1;
                        // post("proj %d = %d",i,x->BCF_projecteur[x->mode_tmp[0]][i]);
                        clique++;
                        if (x->BCF_data[x->mode_tmp[0]][i] == 1)
                        {
                            // actualise la BCF avec un envoie midi
                            SETFLOAT(&element[0],x->mode_tmp[0]); //num_fader
                            SETFLOAT(&element[1],x->valeur_data[(int)x->effet[i][1]-1]); //valeur
                            outlet_anything(x->to_gem,gensym("to_BCF"),2,element);
                            // actualise l'affichage de la bcf
                            x->BCF[x->mode_tmp[0]] = x->valeur_data[(int)x->effet[i][1]-1];
                        }
                    }
                } 
                if (x->groupe[i][1]!=0)
                {
                    if ((fabs(x->groupe[i][3] - x->mouseX)<0.05)&(fabs(x->groupe[i][4] - x->mouseY)<0.05))
                    {
                        // post("bcf %d = groupe%d",x->mode_tmp[0],i);
                        clique++;
                        for (j=0; j<x->groupe[i][12]; j++) // add les proj du groupe
                        {
                            // post("add proj %f au pot %d de la bcf",x->groupe[i][13+j], x->mode_tmp[0] );
                            x->BCF_projecteur[x->mode_tmp[0]][(int)x->groupe[i][13+j]] = 1;
                        }

                    }
                } 
            }
            // si element_clique == 0, alors on passe au fader suivant
            if (clique == 0)
                {
                    x->mode_tmp[0]++;
                    x->control=0;
                    if ((x->mode_tmp[0] == 8)|(x->mode_tmp[0] == 16))
                        x->mode=mode_jeu_drag;
                }

        }        
    }
}

void jotac_GEM_kernel_bang(t_jotac_GEM_kernel *x)
{
//    post("bang");
    int i,j;
    t_atom menu_valeur;
    t_atom element_pdf[nb_max_DMX];
    SETFLOAT(&menu_valeur, x->menu);
    outlet_anything(x->to_gem,gensym("menu"),1,&menu_valeur);

    switch (x->menu)
    {
    case menu_patch:
        break;
    case menu_DMX:
        for(i=0; i<nb_max_circuit; i++)
        {
            SETFLOAT(&element_pdf[i], x->valeur_DMX[i] );
        }
        outlet_anything(x->to_gem,gensym("list_dmx"), nb_max_circuit,element_pdf);
        break;
    case menu_edition:
        // TODO : groupe, text
        for(i=0; i<nb_max_circuit;i++)
        { // forme
            if (x->forme[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("forme"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->forme[i][j]); 
                SETFLOAT(&element_pdf[13],0); // pointed : TODO (en fct des groupes)
                outlet_anything(x->to_gem,gensym("pdf_edition"),14,element_pdf);
            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { // texte
            if (x->texte[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("texte"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->texte[i][j]); 
                SETFLOAT(&element_pdf[13],0); // pointed : TODO (en fct des groupes)
                SETFLOAT(&element_pdf[14],x->texte[i][12]); // nb_lettre
                for(j=0; j<x->texte[i][12]; j++)
                    SETFLOAT(&element_pdf[j+15],x->texte[i][j+13]); 
                outlet_anything(x->to_gem,gensym("pdf_edition"),14+x->texte[i][12],element_pdf);
            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { // groupe
            if (x->groupe[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("groupe"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->groupe[i][j]); 
                SETFLOAT(&element_pdf[12],0); // pointed : TODO (en fct des groupes)
//                SETFLOAT(&element_pdf[13],x->groupe[i][12]); // nb_lettre
//                for(j=0; j<x->groupe[i][12]; j++)
//                    SETFLOAT(&element_pdf[j+14],x->groupe[i][j+13]); 
//                outlet_anything(x->to_gem,gensym("pdf_edition"),14+x->groupe[i][12],element_pdf);
                  outlet_anything(x->to_gem,gensym("pdf_edition"),13,element_pdf);
            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { // data
            if (x->data[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("data"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->data[i][j]); 
                SETFLOAT(&element_pdf[13],0); // pointed
                outlet_anything(x->to_gem,gensym("pdf_edition"),14,element_pdf);            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { // effet
            if (x->effet[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("effet"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->effet[i][j]); 
                SETFLOAT(&element_pdf[13],0); // pointed
                outlet_anything(x->to_gem,gensym("pdf_edition"),14,element_pdf);
            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { // projecteur
            if (x->projecteur[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("projecteur"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->projecteur[i][j]); 
                SETFLOAT(&element_pdf[13],0); 
                if (x->selected_groupe >= 0)
                {
                    for (j=0; j < x->groupe[x->selected_groupe][12]; j++)
                        if (x->groupe[x->selected_groupe][j+13]==i)
                            SETFLOAT(&element_pdf[13],1);
                    // post("groupe %d avec %d proj", (int)x->selected_groupe, (int)x->groupe[x->selected_groupe][10]);
                }
                outlet_anything(x->to_gem,gensym("pdf_edition"),14,element_pdf);
            }
        }
        break;
    case menu_jeu:
        for(i=0; i<nb_max_circuit;i++)
        {
            x->projecteur[i][12] =0; // raz du bit pointed
        }
        for(i=0; i<nb_max_circuit;i++)
        { // forme
            if (x->forme[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("forme"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->forme[i][j]); 
                SETFLOAT(&element_pdf[13],0); // pointed : TODO (en fct des groupes)
                outlet_anything(x->to_gem,gensym("pdf_jeu"),14,element_pdf);
            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { // texte
            if (x->texte[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("texte"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->texte[i][j]); 
                SETFLOAT(&element_pdf[13],0); // pointed : TODO (en fct des groupes)
                SETFLOAT(&element_pdf[14],x->texte[i][12]); // nb_lettre
                for(j=0; j<x->texte[i][12]; j++)
                    SETFLOAT(&element_pdf[j+15],x->texte[i][j+13]); 
                outlet_anything(x->to_gem,gensym("pdf_jeu"),14+x->texte[i][12],element_pdf);
            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { // data
            if (x->data[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("data"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->data[i][j]); 
                SETFLOAT(&element_pdf[13],0); // pointed
                SETFLOAT(&element_pdf[14],x->valeur_data[(int)x->data[i][1]-1]); // valeur de la sortie 
                if(x->mode == mode_jeu_set)// mode add fader BCF
                {
                    // ecrase la selection avec la bcf
                    SETFLOAT(&element_pdf[1],x->BCF_data[x->mode_tmp[0]][i]);
                }
                outlet_anything(x->to_gem,gensym("pdf_jeu"),15,element_pdf); 
            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { // effet
            if (x->effet[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("effet"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->effet[i][j]); 
                SETFLOAT(&element_pdf[13],0); // pointed
                SETFLOAT(&element_pdf[14],x->valeur_effet[(int)x->effet[i][1]-1]); // valeur de la sortie 
                if(x->mode == mode_jeu_set)// mode add fader BCF
                {
                    // ecrase la selection avec la bcf
                    SETFLOAT(&element_pdf[1],x->BCF_effet[x->mode_tmp[0]][i]);
                }
                outlet_anything(x->to_gem,gensym("pdf_jeu"),15,element_pdf);
            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { // groupe
            if (x->groupe[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("groupe"));
                for (j=0; j<12; j++)
                    SETFLOAT(&element_pdf[j+1],x->groupe[i][j]); 
                SETFLOAT(&element_pdf[13],0); // pointed
                outlet_anything(x->to_gem,gensym("pdf_jeu"),14,element_pdf);
                
                if (x->groupe[i][0] != 0) // TODO a virer???
                    for (j=13; j< 13+x->groupe[i][12]; j++)
                        x->projecteur[ (int)x->groupe[i][j] ][12] = 1;
            }
        }
        for(i=0; i<nb_max_circuit;i++)
        { //projecteur
            if (x->projecteur[i][1] != 0) 
            {
                SETSYMBOL(&element_pdf[0], gensym("projecteur"));
                for (j=0; j<13; j++)
                    SETFLOAT(&element_pdf[j+1],x->projecteur[i][j]); 
                SETFLOAT(&element_pdf[14],x->valeur_circuit[(int)x->projecteur[i][1]-1]); // valeur de la memoire
                SETFLOAT(&element_pdf[15],x->valeur_bus_lumiere[(int)x->projecteur[i][1]-1]); // valeur de la sortie 
                if(x->mode == mode_jeu_set)// mode add fader BCF
                {
                    // ecrase la selection avec la bcf
                    SETFLOAT(&element_pdf[1],x->BCF_projecteur[x->mode_tmp[0]][i]);
                }
                outlet_anything(x->to_gem,gensym("pdf_jeu"),16,element_pdf);
            }
        }
        for (i=0; i<16; i++)
            SETFLOAT(&element_pdf[i],x->BCF[i]); 
        outlet_anything(x->to_gem,gensym("BCF"),16,element_pdf);
        if (x->mode == mode_jeu_set)
        {
            SETFLOAT(&element_pdf[0],x->mode_tmp[0]);
            outlet_anything(x->to_gem,gensym("set_BCF"),1,element_pdf);
        }
        break;
        
    case menu_effet:
        break;
    case menu_memoire:
    // envoyer les valeur des circuits,  effet et data
        SETFLOAT(&element_pdf[0], x->aff_offset );
        for(i=0; i<32; i++)
            SETFLOAT(&element_pdf[i+1], x->valeur_circuit[i+(int)x->aff_offset] );
        outlet_anything(x->to_gem,gensym("valeur_circuit"),33,element_pdf);
        for(i=0; i<32; i++)
            SETFLOAT(&element_pdf[i+1], x->valeur_effet[i+(int)x->aff_offset] );
        outlet_anything(x->to_gem,gensym("valeur_effet"),33,element_pdf);
        for(i=0; i<32; i++)
            SETFLOAT(&element_pdf[i+1], x->valeur_data[i+(int)x->aff_offset] );
        outlet_anything(x->to_gem,gensym("valeur_data"),33,element_pdf);
        for(i=0; i<32; i++)
            SETFLOAT(&element_pdf[i+1], x->valeur_bus_lumiere[i+(int)x->aff_offset] );
        outlet_anything(x->to_gem,gensym("valeur_bus"),33,element_pdf);
        break;
    case menu_timeline:
        break;
    case menu_restitution:
        break;
    }

    x->mouse_state = 0;
    if ((x->mode == mode_edition_move)&(x->menu==menu_edition))
        x->mouse_state = 1; 
    if ((x->mode == mode_edition_rotate)&(x->menu==menu_edition))
        x->mouse_state = 2; 
    if ((x->mode == mode_edition_scale)&(x->menu==menu_edition))
        x->mouse_state = 3; 
    if ((x->mode == mode_edition_delete)&(x->menu==menu_edition))
        x->mouse_state = 5; 
    if ((x->mode == mode_edition_add)&(x->menu==menu_edition))
        x->mouse_state = 4; 
    if ((x->mode == mode_edition_color)&(x->menu==menu_edition))
        x->mouse_state = 7; 
    if ((x->mode == mode_edition_type)&(x->menu==menu_edition))
        x->mouse_state = 8; 
    if ((x->mode == mode_edition_number)&(x->menu==menu_edition))
        x->mouse_state = 6; 
    if ((x->mode == mode_edition_groupe)&(x->menu==menu_edition))
        x->mouse_state = 4; 
    if ((x->menu==menu_jeu)&(x->mousedrag == 1)&(x->mode==mode_jeu_drag))
        x->mouse_state = 6; 
    if ((x->menu==menu_jeu)&(x->mousedrag == 1)&(x->mode==mode_jeu_drag_BCF))
        x->mouse_state = 6; 
    if ((x->menu==menu_jeu)&(x->mode==mode_jeu_set))
        x->mouse_state = 4; 
    if ((x->menu==menu_DMX)&(x->mode==mode_DMX_play))
        x->mouse_state = 6;
    if ((x->menu==menu_memoire)&(x->mousedrag == 1))
        x->mouse_state = 6;

    SETFLOAT(&element_pdf[0], x->mouse_state);
    SETFLOAT(&element_pdf[1], x->mouseX);
    SETFLOAT(&element_pdf[2], x->mouseY);
    outlet_anything(x->to_gem,gensym("mouse"),3,element_pdf);
}

void jotac_GEM_kernel_list(t_jotac_GEM_kernel *x, t_symbol *s, int argc, t_atom *argv)
{ // TODO groupe / texte
    int i,j;
    if (atom_getsymbolarg(0, argc, argv) == gensym("projecteur"))
    {   // projecteur
        j = (int)atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        for(i=0; (i<12)&(i<argc-2); i++)
            x->projecteur[j][i+1] = atom_getfloatarg(i+2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("change_projecteur")) // TODO limiter a 3 arg
    {   // projecteur change
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        x->projecteur[j][1+(int)atom_getfloatarg(2,argc,argv)] = atom_getfloatarg(3,argc,argv); // TOO protection contre l'ecriture hors du tableau en i et j
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("effet"))
    {   
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        for(i=0; (i<12)&(i<argc-2); i++)
            x->effet[j][i+1] = atom_getfloatarg(i+2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("change_effet"))
    {   
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        x->effet[j][1+(int)atom_getfloatarg(2,argc,argv)] = atom_getfloatarg(3,argc,argv); // TOO protection contre l'ecriture hors du tableau en i et j
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("data"))
    {   
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        for(i=0; (i< 12)&(i<argc-2); i++)
            x->data[j][i+1] = atom_getfloatarg(i+2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("change_data"))
    {   
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        x->data[j][1+(int)atom_getfloatarg(2,argc,argv)] = atom_getfloatarg(3,argc,argv); // TOO protection contre l'ecriture hors du tableau en i et j
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("forme")) 
    {   
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        for(i=0; (i< 12)&(i<argc-2); i++)
            x->forme[j][i+1] = atom_getfloatarg(i+2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("change_forme"))
    {   
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        x->forme[j][1+(int)atom_getfloatarg(2,argc,argv)] = atom_getfloatarg(3,argc,argv); // TOO protection contre l'ecriture hors du tableau en i et j
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("groupe"))
    {
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        for(i=0; i< 12 + atom_getfloatarg(13,argc,argv); i++)
            x->groupe[j][i+1] = atom_getfloatarg(i+2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("change_groupe"))
    {   
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        x->groupe[j][1+(int)atom_getfloatarg(2,argc,argv)] = atom_getfloatarg(3,argc,argv); // TOO protection contre l'ecriture hors du tableau en i et j
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("texte")) // TODO
    {
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        for(i=0; i< 12 + atom_getfloatarg(13,argc,argv); i++)
            x->texte[j][i+1] = atom_getfloatarg(i+2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("change_texte"))
    {   
        j = atom_getfloatarg(1,argc,argv);
        if (j>=nb_max_circuit) j = nb_max_circuit-1; //si on essaye d'ecrire en dehors de la taille memoire defini
        x->texte[j][1+(int)atom_getfloatarg(2,argc,argv)] = atom_getfloatarg(3,argc,argv); // TOO protection contre l'ecriture hors du tableau en i et j
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("valeur_circuit"))
    { // TODO verifier le nb d'argument
        // TODO si il y a plus de donées, les ecrire a la suite
        x->valeur_circuit[(int)atom_getfloatarg(1,argc,argv)-1] = atom_getfloatarg(2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("valeur_effet"))
    { // TODO verifier le nb d'argument
        // TODO si il y a plus de donées, les ecrire a la suite
        x->valeur_effet[(int)atom_getfloatarg(1,argc,argv)-1] = atom_getfloatarg(2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("valeur_data"))
    { // TODO verifier le nb d'argument
        // TODO si il y a plus de donées, les ecrire a la suite
        x->valeur_data[(int)atom_getfloatarg(1,argc,argv)-1] = atom_getfloatarg(2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("valeur_bus"))
    { // TODO verifier le nb d'argument
        // TODO si il y a plus de donées, les ecrire a la suite
        x->valeur_bus_lumiere[(int)atom_getfloatarg(1,argc,argv)-1] = atom_getfloatarg(2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("valeur_DMX"))
    { // TODO verifier le nb d'argument
        // TODO si il y a plus de donées, les ecrire a la suite
        x->valeur_DMX[(int)atom_getfloatarg(1,argc,argv)-1] = atom_getfloatarg(2,argc,argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("menu"))
    {   // post ("menu %d",x->menu);
        x->menu = atom_getfloatarg(1, argc, argv);
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("list_circuits"))
    {
        i=0;
        while ((i<nb_max_circuit)&(i<argc-1))
        {
            x->valeur_bus_lumiere[i] = atom_getfloatarg(i+1, argc, argv);
            i++;
        }
    }
    else
    if (atom_getsymbolarg(0, argc, argv) == gensym("list_dmx"))
    {
        i=0;
        while ((i<nb_max_circuit)&(i<argc-1))
        {
            x->valeur_DMX[i] = atom_getfloatarg(i+1, argc, argv);
            i++;
        }
    }
}

void jotac_GEM_kernel_mouse_pos(t_jotac_GEM_kernel *x, t_float mousePosX, t_float mousePosY, t_float mousePosX_menu, t_float mousePosX_PdF)
{
    t_float dX,dY; // deplacement de la sourie
    t_atom element[5];
    int i;
    
    dX = mousePosX-x->mouseX;
    dY = mousePosY-x->mouseY;
    
    x->mouseX = mousePosX;
    x->mouseY = mousePosY;
    x->mouseXmenu = mousePosX_menu;
    x->mouseXpdf = mousePosX_PdF;
    if ((x->menu == menu_edition)&(x->mode == mode_edition_move)  &(x->mousedrag==1))
        drag_selected(x,dX,dY);
    else
    if ((x->menu == menu_edition)&(x->mode == mode_edition_rotate)&(x->mousedrag==1))
        rot_selected(x,dX,dY);
    else
    if ((x->menu == menu_edition)&(x->mode == mode_edition_scale) &(x->mousedrag==1))
        scale_selected(x,dX,dY);
    else
    if ((x->menu == menu_edition)&(x->mode == mode_edition_number)&(x->mousedrag==1))
        number_selected(x,dX,dY);
    else
    if ((x->menu == menu_memoire)&(x->mousedrag==1))
        number_memoire(x,dX,dY/3);
    else
    if ((x->menu == menu_jeu)&(x->mousedrag==1)&(x->mode == mode_jeu_drag))
        value_selected(x,dX,dY);
    if ((x->menu == menu_jeu)&(x->mousedrag==1)&(x->mode == mode_jeu_drag_BCF))
        { // incremente le fader de la bcf
            x->BCF[x->mode_tmp[0]] += dY*2.5;
            x->BCF[x->mode_tmp[0]] = fmin(1,fmax(0,x->BCF[x->mode_tmp[0]]));
            // actualiser les projecteurs, effet, data associé a ce fader
            for (i=0; i<nb_max_circuit; i++)
            {
                if (x->BCF_projecteur[x->mode_tmp[0]][i] > 0)
                {
                    SETSYMBOL(&element[0], gensym("circuit"));
                    SETFLOAT(&element[1],(int)x->projecteur[i][1]); // index
                    SETFLOAT(&element[2],x->BCF[x->mode_tmp[0]]); // valeur 
                    outlet_anything(x->to_jotac,gensym("rampe"),3,element);
                }
                if (x->BCF_effet[x->mode_tmp[0]][i] > 0)
                {
                    SETSYMBOL(&element[0], gensym("effet"));
                    SETFLOAT(&element[1],(int)x->effet[i][1]); // index
                    SETFLOAT(&element[2],x->BCF[x->mode_tmp[0]]); // valeur 
                    outlet_anything(x->to_jotac,gensym("rampe"),3,element);
                }
                if (x->BCF_data[x->mode_tmp[0]][i] > 0)
                {
                    SETSYMBOL(&element[0], gensym("data"));
                    SETFLOAT(&element[1],(int)x->data[i][1]); // index
                    SETFLOAT(&element[2],x->BCF[x->mode_tmp[0]]); // valeur 
                    outlet_anything(x->to_jotac,gensym("rampe"),3,element);
                }
            }
            // actualise la BCF avec un envoie midi
            SETFLOAT(&element[0],x->mode_tmp[0]); //num_fader
            SETFLOAT(&element[1],x->BCF[x->mode_tmp[0]]); //valeur
            outlet_anything(x->to_gem,gensym("to_BCF"),2,element);
        }
    else
    if ((x->menu == menu_DMX)&(x->mousedrag==1)&(x->mode == mode_DMX_play))
        drag_DMX(x,dY);
    else
    if ((x->menu == menu_DMX)&(x->mousedrag==1)&(x->mode == mode_DMX_move_all))
        drag_all_DMX(x,dY);
}

void jotac_GEM_kernel_mouse_click(t_jotac_GEM_kernel *x, t_float mouseClick)
{
    // post("mouse click");

    x->mousedrag = mouseClick; 
    t_atom element[2];

    if ((mouseClick==1)&(x->mouseXmenu<=1)&(x->mouseY>0.9))
        { x->menu = (int)(x->mouseXmenu * 8); x->mode = 0; }
    else
    if ((x->menu == menu_edition)&(mouseClick==1)&(x->mouseXmenu<=1))
        click_menu_edition(x);
    else
    if ((x->menu == menu_edition)&(mouseClick==1)&(x->mouseXmenu>1))
        click_pdf_edition(x);
    else
    if ((x->menu == menu_edition)&(mouseClick==1)&(x->mouseXmenu>1))
        click_pdf_edition(x);
    else
    if ((x->menu == menu_jeu)&(mouseClick==1)&(x->mouseXmenu>1))
        click_pdf_jeu(x);
    else
    if ((x->menu == menu_jeu)&(mouseClick==1)&(x->mouseXmenu<1))
        click_menu_jeu(x);
    else
    if ((x->menu == menu_memoire)&(mouseClick==1)&(x->mouseXmenu>1))
        click_pdf_memoire(x);
    else
    if ((x->menu == menu_DMX)&(mouseClick==1)&(x->mouseXmenu>1)&(x->mode==mode_DMX_play))
        x->num_DMX = floor(x->mouseXpdf*32) + 32* floor((x->mouseY-1)*-8);
    else
    if ((x->menu == menu_DMX)&(mouseClick==1)&(x->mouseXmenu<=1))
    {
        x->num_DMX = -1;   
        if ((fabs(x->mouseY - 0.7)< 0.05) & (x->mouseXmenu*8 <= 3))
            x->mode = (int)(x->mouseXmenu*8);
    }
    else
    if ((x->menu == menu_DMX)&(x->mode==mode_DMX_flash)&(x->mouseXmenu>1))
    {
        SETFLOAT(&element[0], 1 + floor(x->mouseXpdf*32) + 32* floor((x->mouseY-1)*-8));
        SETFLOAT(&element[1],mouseClick); 
        outlet_anything(x->to_jotac,gensym("force_DMX"),2,element);
    }
}

void jotac_GEM_kernel_key(t_jotac_GEM_kernel *x,  t_symbol *s, int argc, t_atom *argv)
{
    // post("key");
    int i;

    if((atom_getsymbolarg(0, argc, argv) == gensym("\x01"))&(atom_getfloatarg(1, argc, argv)==1)) // control A
    for(i=0;i<nb_max_circuit;i++)
    { 
        if (x->projecteur[i][0]!=0)
            x->projecteur[i][9]=1;
        if (x->effet[i][0]!=0)
            x->effet[i][9]=1;
        if (x->data[i][0]!=0)
            x->data[i][9]=1;
        if (x->groupe[i][0]!=0)
            x->groupe[i][9]=1;
        if (x->forme[i][0]!=0)
            x->forme[i][9]=1;
        if (x->texte[i][0]!=0)
            x->texte[i][9]=1;
    }
    else
    if((atom_getsymbolarg(0, argc, argv) == gensym("a"))&(atom_getfloatarg(1, argc, argv)==1)) // a
    for(i=0;i<nb_max_circuit;i++)
    { 
        if (x->projecteur[i][0]!=0)
            x->projecteur[i][9]=0;
        if (x->effet[i][0]!=0)
            x->effet[i][9]=0;
        if (x->data[i][0]!=0)
            x->data[i][9]=0;
        if (x->groupe[i][0]!=0)
            x->groupe[i][9]=0;
        if (x->forme[i][0]!=0)
            x->forme[i][9]=0;
        if (x->texte[i][0]!=0)
            x->texte[i][9]=0;
    }
    if(atom_getsymbolarg(0, argc, argv) == gensym("Control_L")) 
        x->mod_ctrl=atom_getfloatarg(1, argc, argv);
    if(atom_getsymbolarg(0, argc, argv) == gensym("Control_R")) 
        x->mod_ctrl=atom_getfloatarg(1, argc, argv);
    if(atom_getsymbolarg(0, argc, argv) == gensym("Shift_R")) 
        x->mod_shift=atom_getfloatarg(1, argc, argv);
    if(atom_getsymbolarg(0, argc, argv) == gensym("Shift_L")) 
        x->mod_shift=atom_getfloatarg(1, argc, argv);

}

void jotac_GEM_kernel_BCF(t_jotac_GEM_kernel *x, t_float CC, t_float val)
{
    x->BCF[(int)CC-1]=val;
    // TODO : limiter les valeur de CC et de val
    // TODO : update des projecteurs
}

void jotac_GEM_kernel_reset(t_jotac_GEM_kernel *x)
{
    post("reset le controleur");
    int i, j;
    for(i=0;i<nb_max_circuit;i++)
    {
        x->projecteur[i][1] = 0;
        x->effet[i][1] = 0;
        x->data[i][1] = 0;
        x->forme[i][1] = 0;
        x->groupe[i][1] = 0;
        x->texte[i][1] = 0;
        
        x->valeur_circuit[i] = 0;
        x->valeur_effet[i] = 0;
        x->valeur_data[i] = 0;
        x->valeur_bus_lumiere[i] = 0;        
    }

    for(i=0;i<nb_max_DMX;i++)
        x->valeur_DMX[i] = 0;        
}

void *jotac_GEM_kernel_new(void)
{
    int i;
    t_jotac_GEM_kernel *x = (t_jotac_GEM_kernel *)pd_new(jotac_GEM_kernel_class);

    x->to_gem=outlet_new(&x->x_obj, 0);
    x->to_jotac=outlet_new(&x->x_obj, 0);

    for(i=0;i<nb_max_circuit;i++)
    {
        x->projecteur[i][0] = 0;
        x->effet[i][0] = 0;
        x->data[i][0] = 0;
        x->forme[i][0] = 0;
        x->groupe[i][0] = 0;
        x->texte[i][0] = 0;
        
        x->valeur_circuit[i] = 0;
        x->valeur_effet[i] = 0;
        x->valeur_data[i] = 0;
        x->valeur_bus_lumiere[i] = 0;        
        
    }

    for(i=0;i<nb_max_DMX;i++)
        x->valeur_DMX[i] = 0;        

    x->mode = 0;
    x->mouse_state = 0;
    x->mod_ctrl = 0;
    x->mod_shift = 0;

    x->selected_groupe = -1;
    
    return (void *)x;
}

void jotac_GEM_kernel_setup(void) {
    jotac_GEM_kernel_class = class_new(gensym("jotac_GEM_kernel"), (t_newmethod)jotac_GEM_kernel_new,
        0, sizeof(t_jotac_GEM_kernel), CLASS_DEFAULT, 0);
    class_addbang(jotac_GEM_kernel_class, jotac_GEM_kernel_bang);
    class_addlist(jotac_GEM_kernel_class, jotac_GEM_kernel_list);
    class_addmethod(jotac_GEM_kernel_class, (t_method)jotac_GEM_kernel_mouse_pos, gensym("mouse_pos"), A_DEFFLOAT, A_DEFFLOAT, A_DEFFLOAT, A_DEFFLOAT, 0);
    class_addmethod(jotac_GEM_kernel_class, (t_method)jotac_GEM_kernel_mouse_click, gensym("mouse_click"), A_DEFFLOAT, 0);
    class_addmethod(jotac_GEM_kernel_class, (t_method)jotac_GEM_kernel_key, gensym("key"), A_GIMME, 0);
    class_addmethod(jotac_GEM_kernel_class, (t_method)jotac_GEM_kernel_BCF, gensym("BCF"), A_DEFFLOAT, A_DEFFLOAT, 0);
    class_addmethod(jotac_GEM_kernel_class, (t_method)jotac_GEM_kernel_reset, gensym("reset"), 0);
}
