from OpenGL.GL import *
from OpenGL.GLU import *
import pygame
from pygame.locals import *
import os
import OpenGL.GL as ogl  
from OpenGL import error
oglError = error
import math

Version = 0.1

texture_edition_proj = []
texture_edition_effect = []
texture_edition_groupe = []
texture_edition_property = []
texture_edition_shape = []
texture_edition_diver = []
texture_edition_nombres = []

def draw_rectangle(taille_X, taille_Y):
    glBegin(GL_QUADS)
    glVertex3f(0, taille_Y, 0)
    glVertex3f(taille_X, taille_Y, 0)
    glVertex3f(taille_X, 0, 0)
    glVertex3f(0, 0, 0)
    glEnd()

def draw_circle(rayon):
    i = 0
    glPushMatrix()
    glScale(rayon,rayon,1)
    glBegin(GL_LINE_LOOP)
    while i <= 16:
        glVertex3f(math.cos(i*0.4), math.sin(i*0.4), 0)
        i += 1
    glVertex3f(1, 0, 0)
    glEnd()
    glPopMatrix()
    
def draw_fader(largeur, hauteur, proportion):
    if proportion <= 0:
        glColor4f(1.,1.,1.,0.1)
    elif proportion == 1:
        glColor4f(1.,1.,1.,1)
    else:
        glColor4f(1.,1.,1.,0.5)
    glBegin(GL_LINE_LOOP)
    glVertex3f(-largeur,  hauteur, 0)
    glVertex3f( largeur,  hauteur, 0)
    glVertex3f( largeur, -hauteur, 0)
    glVertex3f(-largeur, -hauteur, 0)
    glEnd()
    glColor4f(0.5, 0.5, 0.5, 0.5)
    glBegin(GL_QUADS)
    glVertex3f(-largeur, hauteur, 0)
    glVertex3f( largeur, hauteur, 0)
    glVertex3f( largeur, hauteur-2*hauteur*proportion, 0)
    glVertex3f(-largeur, hauteur-2*hauteur*proportion, 0)
    glEnd()

def drawText(textString, taille):     
    font = pygame.font.Font (None, taille)
    textSurface = font.render(textString, True, (255,255,255,255), (0,0,0,0))     
    textData = pygame.image.tostring(textSurface, "RGBA", True)     
    glRasterPos3d(0,0,0)     
    glDrawPixels(textSurface.get_width(), textSurface.get_height(), GL_RGBA, GL_UNSIGNED_BYTE, textData)


def draw_cursor(x,y):
    glColor4f(1.,1.,1.,1.)
    glLoadIdentity()
    glTranslatef(x,y,0.0)
    glScalef(0.001,0.001,1.)

    glBegin(GL_QUADS)
    glVertex3f(-1.0, 1.0, 0)
    glVertex3f(1.0, 1.0, 0)
    glVertex3f(1.0, -1.0, 0)
    glVertex3f(-1.0, -1.0, 0)
    glEnd()

def draw_projecteur(object):
    glTranslatef(object.position[0],object.position[1], 0.)
    glPushMatrix()
    glColor4f(object.color[0],object.color[1],object.color[2],1.)
    glRotatef(object.rotation,0.,0.,1.)
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texture_edition_proj[object.proj_type])
    glBegin(GL_QUADS)
    glTexCoord2f(0.0, 0.0)
    glVertex3f(-30.0, -30.0,  0.0)	# Bottom Left Of The Texture and Quad
    glTexCoord2f(1.0, 0.0)
    glVertex3f( 30.0, -30.0,  0.0)	# Bottom Right Of The Texture and Quad
    glTexCoord2f(1.0, 1.0)
    glVertex3f( 30.0,  30.0,  0.0)	# Top Right Of The Texture and Quad
    glTexCoord2f(0.0, 1.0)
    glVertex3f(-30.0,  30.0,  0.0)	# Top Left Of The Texture and Quad		
    glEnd()
    glFlush()
    glDisable(GL_TEXTURE_2D)
    glPopMatrix()

def draw_groupe(object):
    glColor4f(1.,1.,1.,1.)
#   glColor4f(object.color[0],object.color[1],object.color[2],1.)
    glTranslatef(object.position[0],object.position[1], 0.)
    glPushMatrix()
##    glRotatef(object.rotation,0.,0.,1.)
    glScale(15,15,1.)
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texture_edition_groupe[object.groupe_type])
    glBegin(GL_QUADS)
    glTexCoord2f(0.0, 0.0)
    glVertex3f(-1.0, -1.0,  0.0)	# Bottom Left Of The Texture and Quad
    glTexCoord2f(1.0, 0.0)
    glVertex3f( 1.0, -1.0,  0.0)	# Bottom Right Of The Texture and Quad
    glTexCoord2f(1.0, 1.0)
    glVertex3f( 1.0,  1.0,  0.0)	# Top Right Of The Texture and Quad
    glTexCoord2f(0.0, 1.0)
    glVertex3f(-1.0,  1.0,  0.0)	# Top Left Of The Texture and Quad		
    glEnd()
    glFlush()
    glDisable(GL_TEXTURE_2D)
    glPopMatrix()

def draw_effect(object):
    glColor4f(1.,1.,1.,1.)
#   glColor4f(object.color[0],object.color[1],object.color[2],1.)
    glTranslatef(object.position[0],object.position[1], 0.)
    glPushMatrix()
##    glRotatef(object.rotation,0.,0.,1.)
    glScale(15,15,1.)
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texture_edition_effect[object.effect_type])
    glBegin(GL_QUADS)
    glTexCoord2f(0.0, 0.0)
    glVertex3f(-1.0, -1.0,  0.0)	# Bottom Left Of The Texture and Quad
    glTexCoord2f(1.0, 0.0)
    glVertex3f( 1.0, -1.0,  0.0)	# Bottom Right Of The Texture and Quad
    glTexCoord2f(1.0, 1.0)
    glVertex3f( 1.0,  1.0,  0.0)	# Top Right Of The Texture and Quad
    glTexCoord2f(0.0, 1.0)
    glVertex3f(-1.0,  1.0,  0.0)	# Top Left Of The Texture and Quad		
    glEnd()
    glFlush()
    glDisable(GL_TEXTURE_2D)
    glPopMatrix()
    
def draw_object(object):
    if object.rectangle_type == 0:
        draw_rectangle_object(object)
    elif object.rectangle_type == 1:
        draw_rectangle2_object(object)
    elif object.rectangle_type == 2:
        draw_cercle_object(object)
    elif object.rectangle_type == 3:
        draw_cercle2_object(object)

def draw_rectangle_object(object):
    glColor4f(object.color[0],object.color[1],object.color[2],object.color[3])
    glTranslatef(object.position[0],object.position[1], 0.)
    glRotatef(object.rotation,0.,0.,1.)

    glScale(object.taille[0],object.taille[1],1.)
    glBegin(GL_QUADS)
    glVertex3f(-1.0, 1.0, 0)
    glVertex3f(1.0, 1.0, 0)
    glVertex3f(1.0, -1.0, 0)
    glVertex3f(-1.0, -1.0, 0)
    glEnd()
    
def draw_rectangle2_object(object):
    glColor4f(object.color[0],object.color[1],object.color[2],object.color[3])
    glTranslatef(object.position[0],object.position[1], 0.)
    glRotatef(object.rotation,0.,0.,1.)

    glScale(object.taille[0],object.taille[1],1.)
    glBegin(GL_LINE_LOOP)
    glVertex3f(-1.0, 1.0, 0)
    glVertex3f(1.0, 1.0, 0)
    glVertex3f(1.0, -1.0, 0)
    glVertex3f(-1.0, -1.0, 0)
    glEnd()

def draw_cercle_object(object):
    glColor4f(object.color[0],object.color[1],object.color[2],object.color[3])
    glTranslatef(object.position[0],object.position[1], 0.)
    glRotatef(object.rotation,0.,0.,1.)
    glScale(object.taille[0],object.taille[1],1.)
    i = 0
    glBegin(GL_TRIANGLE_FAN)
    glVertex3f(0., 0., 0)
    while i <= 31:
        glVertex3f(math.cos(i*0.2), math.sin(i*0.2), 0)
        i += 1
    glVertex3f(1, 0, 0)
    glEnd()

def draw_cercle2_object(object):
    glColor4f(object.color[0],object.color[1],object.color[2],object.color[3])
    glTranslatef(object.position[0],object.position[1], 0.)
    glRotatef(object.rotation,0.,0.,1.)
    glScale(object.taille[0],object.taille[1],1.)
    i = 0
    glBegin(GL_LINE_LOOP)
    while i <= 32:
        glVertex3f(math.cos(i*0.2), math.sin(i*0.2), 0)
        i += 1
    glVertex3f(1, 0, 0)
    glEnd()
    
def draw_1_texture(position,taille,texture):
    glPushMatrix()
    glTranslate(position[0],position[1],0)
    glScale(taille,taille,1.)
    glColor4f(1,1,1,1.)
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texture)
    glBegin(GL_QUADS)
    glTexCoord2f(0.0, 0.0)
    glVertex3f(0, 0,  0.0)	# Bottom Left Of The Texture and Quad
    glTexCoord2f(1.0, 0.0)
    glVertex3f(1, 0,  0.0)	# Bottom Right Of The Texture and Quad
    glTexCoord2f(1.0, 1.0)
    glVertex3f(1, 1,  0.0)	# Top Right Of The Texture and Quad
    glTexCoord2f(0.0, 1.0)
    glVertex3f(0, 1,  0.0)	# Top Left Of The Texture and Quad		
    glEnd()
    glFlush()
    glDisable(GL_TEXTURE_2D)
    glPopMatrix()

def load_textures(n,string):
    texturefile = os.path.join('img',string)
    textureSurface = pygame.image.load(texturefile)
    textureData = pygame.image.tostring(textureSurface, "RGBX", 0)
    texture_list = glGenTextures(1)
    glBindTexture(GL_TEXTURE_2D, texture_list)
    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, textureSurface.get_width(), textureSurface.get_height(), 0, GL_RGBA, GL_UNSIGNED_BYTE, textureData )
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
    return [texture_list]

def resize((width, height)):
    if height==0:
        height=1
    glViewport(0, 0, width, height)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glOrtho(0.,1.,float(height)/width,0.,-10.,10.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

def quickCheckError(*args, **kwargs):
    return None
    
def init():    
    glShadeModel(GL_SMOOTH)
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClearDepth(1.0)
    glDisable(GL_DEPTH_TEST)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)
    glEnable(GL_BLEND)
    glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA )    
def import_texture():
    global texture_edition_proj
    global texture_edition_groupe
    global texture_edition_effect
    global texture_edition_property
    global texture_edition_shape
    global texture_edition_diver
    global texture_edition_nombres
    
    glEnable(GL_TEXTURE_2D)
    texture_edition_proj += load_textures(0,'proj0.png')
    texture_edition_proj += load_textures(1,'proj1.png')
    texture_edition_proj += load_textures(2,'proj2.png')
    texture_edition_proj += load_textures(3,'proj3.png')
    texture_edition_proj += load_textures(4,'proj4.png')
    texture_edition_proj += load_textures(5,'proj5.png')
    texture_edition_effect += load_textures(0,'effect0.bmp')
    texture_edition_effect += load_textures(1,'effect1.bmp')
    texture_edition_effect += load_textures(2,'effect2.bmp')
    texture_edition_effect += load_textures(3,'effect3.bmp')
    texture_edition_effect += load_textures(4,'effect4.bmp')
    texture_edition_effect += load_textures(5,'effect5.bmp')
    ## TODO : faire une boucle sur toutes les textures possible
    texture_edition_property += load_textures(0,'color_red.png')
    texture_edition_property += load_textures(1,'color_green.png')
    texture_edition_property += load_textures(2,'color_blue.png')
    texture_edition_property += load_textures(3,'move.png')
    texture_edition_property += load_textures(4,'rotate.png')
    texture_edition_property += load_textures(5,'del.png')
    texture_edition_groupe += load_textures(0,'groupe0.png')
    texture_edition_groupe += load_textures(1,'groupe1.png')
    texture_edition_groupe += load_textures(2,'groupe2.png')
    texture_edition_groupe += load_textures(3,'groupe3.png')
    texture_edition_groupe += load_textures(4,'groupe4.png')
    texture_edition_groupe += load_textures(5,'groupe5.png')
    texture_edition_shape += load_textures(0,'add_rectangle.png')
    texture_edition_shape += load_textures(1,'add_rectangle2.png')
    texture_edition_shape += load_textures(2,'add_circle.png')
    texture_edition_shape += load_textures(3,'add_circle2.png')
    texture_edition_diver += load_textures(0,'change_type.png')
    texture_edition_diver += load_textures(1,'object_alpha.png')
    texture_edition_diver += load_textures(2,'object_resize.png')
    texture_edition_diver += load_textures(3,'add.png')
    texture_edition_diver += load_textures(4,'sup.png')
    texture_edition_diver += load_textures(5,'rec.png')
    texture_edition_diver += load_textures(6,'rec_sel.png')
    for i in range(512) :
        texture_edition_nombres += load_textures(4,'nombres/nombre_' + str(i) + '.png')
def init_screen(fullscreen, fullscreensize):
    if fullscreen:
        video_flags = OPENGL|DOUBLEBUF|FULLSCREEN
        screensize = fullscreensize
    else:
        video_flags = OPENGL|DOUBLEBUF
        screensize = (960,600)
    pygame.display.set_caption('JOT V' + str(Version))
    pygame.display.gl_set_attribute(pygame.GL_MULTISAMPLEBUFFERS, 1)
    pygame.display.gl_set_attribute(pygame.GL_MULTISAMPLESAMPLES, 4) # FSAA 4
    pygame.display.set_mode(screensize, video_flags)
    resize(screensize)
    return screensize

