#!/usr/bin/env python
# pygame + PyOpenGL
# test d'interface hergonomique de control de plan de feu
# Cette interface est dediee a piloter un jeu d'orgue ou une emulation de jeu d'orgue
# cf lighting for pure data
# Cyrille Henry 12 2009 / 01 2010

import os,  sys
from OpenGL.GL import *
from OpenGL.GLU import *
import pygame
from pygame.locals import *
import Scenes
import load_save
import draw
import test_mouse
import BCF
import Pd
import threading

# fullscreen = True
fullscreen = False

taille_menu = 0.2


def getMouse() :
    X,Y = pygame.mouse.get_pos()
    X /= float(screensize[0])
    Y /= float(screensize[0])
    return X,Y

#--------------------------------------------------------------------------------------------
pygame.init()
fullscreensize = (pygame.display.Info().current_w,pygame.display.Info().current_h) 
screensize = draw.init_screen(fullscreen,fullscreensize)

draw.init()
draw.import_texture()

Pd.mypdconnection.init()
Pd.pdconnected.init()

Pd.pdconnected.start()
print "ok"

ticks = pygame.time.get_ticks()
Go = True
Mode = 'Jeu'
nom_save = os.path.join('save','scene.txt')

try :
    scene = load_save.load(nom_save)
except IOError:
    scene = Scenes.Scene() # nouvelle scene vide

pixel_to_cm = scene.get_taille() / (screensize[0] * (1.-taille_menu))

if scene.get_interact_object_list_size() == 0:
    # ajout d'un element graphique pour pas avoir de liste vide
    proj = Scenes.Projecteur(0)
    scene.add_object(proj)

selected_edition = 0 # numero de l'obj de la scenne qui est selectionne
selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
selected_jeu = 0 # numero de l'obj de la scenne qui est selectionne
selected_jeu_obj = scene.get_object(scene.get_interact_object_list()[selected_jeu])
edit = 'null' # machine a etat du menu
num_fader = 0 # utile pour la machine a etat du mode jeu

# mode possible :
##  DMX         : pour jouer en direct avec les cannaux DMX afin de tester des circuits 
#   edition     : permet de configurer les projecteur / (groupes) / effet
##  effet       : defini les effet
#   jeu         : permet de jouer avec ces projecteur, groupes et effets
##  memoire     : permet de sauver un etat en memoire, et de gerer l'ordre des memoires ainsi que leurs transitions
##  restitution : permet de passer d'une memoire a l'autre

mouse_button_click = False
mouse_button_unclick = False



while Go:
# limiter a 50 fps, pour etre syncro avec le DMX, et pas utiliser tout le cpu si la boucle tourne a fond
    clock = pygame.time.Clock().tick(50)
    
# deal with key events
    if mouse_button_click and (edit == 'add' or edit == 'del' or edit == 'sel_fader'):
        # on a clicke qq part en mode add qui n'a pas ete gere.
        # alors on revien au mode null
        edit = 'null'
    mouse_button_click = False
    mouse_button_unclick = False
    mouse_button_drag = (pygame.mouse.get_pressed()[0] == 1)
    X,Y = getMouse()

# deal with midi messages (received via socket
#    Pd.pdconnected.receive()

# gestion des evenements clavier et flag des evenement sourie
    for event in pygame.event.get():
        if event.type == QUIT or (event.type == KEYDOWN and event.key == K_ESCAPE and event.mod == 1):
            Go = False
        if event.type == KEYDOWN and event.key == K_f:
            fullscreen = not fullscreen
            screensize = draw.init_screen(fullscreen, fullscreensize)
            pixel_to_cm = scene.get_taille() / (screensize[0] * (1.-taille_menu))
        if event.type == MOUSEBUTTONDOWN and event.button == 1:
            mouse_button_click = True
        if event.type == MOUSEBUTTONUP and event.button == 1:
            mouse_button_unclick = True
            mouse_button_click = False
        if event.type == KEYDOWN and event.key == K_TAB and Mode=='Edition':
            if event.mod == 1:
                selected_edition -= 1 # numero de l'obj de la scenne qui est selectionne
            else:
                selected_edition += 1 # numero de l'obj de la scenne qui est selectionne
            selected_edition = selected_edition % len(scene.get_graphical_object_list())
            selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
        if event.type == KEYDOWN and event.key == K_TAB and Mode=='Jeu':
            if event.mod == 1:
                selected_jeu -= 1 # numero de l'obj de la scenne qui est selectionne
            else:
                selected_jeu += 1 # numero de l'obj de la scenne qui est selectionne
            selected_jeu = selected_jeu % len(scene.get_interact_object_list())
            selected_jeu_obj = scene.get_object(scene.get_interact_object_list()[selected_jeu])
# gestion de la sourie a travers un machine a etat 
# mode edit : (red / green / blue / alpha / pos / rot / size / Control / num_effect / num_proj)
# mode jeu : (mvt_fader / sel_fader ?)

    if edit != 'null':
        if edit == 'red':
            mvt = pygame.mouse.get_rel()[1] / -100.
            tmp = selected_edition_obj.color[0]+mvt
            tmp=min(tmp,1)
            tmp=max(tmp,0)
            selected_edition_obj.color = (tmp,selected_edition_obj.color[1],selected_edition_obj.color[2],selected_edition_obj.color[3])
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'green':
            mvt = pygame.mouse.get_rel()[1] / -100.
            tmp = selected_edition_obj.color[1]+mvt
            tmp=min(tmp,1)
            tmp=max(tmp,0)
            selected_edition_obj.color = (selected_edition_obj.color[0],tmp,selected_edition_obj.color[2],selected_edition_obj.color[3])
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'blue':
            mvt = pygame.mouse.get_rel()[1] / -100.
            tmp = selected_edition_obj.color[2]+mvt
            tmp=min(tmp,1)
            tmp=max(tmp,0)
            selected_edition_obj.color = (selected_edition_obj.color[0],selected_edition_obj.color[1],tmp,selected_edition_obj.color[3])
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'alpha':
            mvt = pygame.mouse.get_rel()[1] / -100.
            tmp = selected_edition_obj.color[3]+mvt
            tmp=min(tmp,1)
            tmp=max(tmp,0)
            selected_edition_obj.color = (selected_edition_obj.color[0],selected_edition_obj.color[1],selected_edition_obj.color[2],tmp)
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'pos':
            mvt = pygame.mouse.get_rel()
            tmp = selected_edition_obj.position
            selected_edition_obj.position = (tmp[0] + mvt[0]*pixel_to_cm , tmp[1] + mvt[1]*pixel_to_cm)
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'rot':
            selected_edition_obj.rotation = (selected_edition_obj.rotation + pygame.mouse.get_rel()[1])%360
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'resize':
            mvt = pygame.mouse.get_rel()
            tmp = selected_edition_obj.taille
            selected_edition_obj.taille = (max(tmp[0] + mvt[0],1) , max(tmp[1] - mvt[1],1))
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'Control':
            if isinstance (selected_jeu_obj, Scenes.Projecteur) or isinstance (selected_jeu_obj, Scenes.Effect):
                selected_jeu_obj.set_value(selected_jeu_obj.get_value()-pygame.mouse.get_rel()[1])
            elif isinstance (selected_jeu_obj, Scenes.Groupe):
                selected_jeu_obj.set_relative_value(-pygame.mouse.get_rel()[1])
#                deplacement = pygame.mouse.get_rel()[1]
#                for projecteur in selected_jeu_obj.get_proj_list():
#                    proj = selected_jeu_obj.get_proj(projecteur)
#                    proj.set_value(proj.get_value()-deplacement)                    
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'num_effect':
            selected_edition_obj.effect_num = (selected_edition_obj.effect_num - pygame.mouse.get_rel()[1])%64
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'num_proj':
            selected_edition_obj.num_proj = (selected_edition_obj.num_proj - pygame.mouse.get_rel()[1])%64
            if mouse_button_unclick:
                edit = 'null'
        elif edit == 'mvt_fader':
            tmp = BCF.myfader.fader[num_fader].get_value() - pygame.mouse.get_rel()[1]
            tmp=min(tmp,100)
            tmp=max(tmp,0)
            BCF.myfader.fader[num_fader].set_value(tmp)
            if mouse_button_unclick:
                edit = 'null'
# ---------------------------------------------
# on clique sur le  Plan de Feu en mode edition : on selectionne un objet si il est sous la sourie
## TODO : taille de selection plus grande pour les proj que pour le reste (??)
    if mouse_button_click and X > taille_menu and  Mode == 'Edition':
        X_pdf = X-taille_menu # pos de la sourie ds les coordonees du PdF
        X_pdf /= 1.-taille_menu
        X_pdf *= scene.get_taille()
        Y_pdf = Y
        Y_pdf /= (1.-taille_menu)
        Y_pdf *= scene.get_taille()
        i=0
        for object in scene.get_graphical_object_list():
            obj = scene.get_object(object).position
            obj_X = obj[0]
            obj_Y = obj[1]
            if X_pdf > (obj_X - 15) and X_pdf < (obj_X + 15) and Y_pdf > (obj_Y - 15) and Y_pdf < (obj_Y + 15):
                if edit == 'add' :
                    if isinstance(scene.get_object(object),Scenes.Projecteur) or isinstance(scene.get_object(object),Scenes.Effect):
                        selected_edition_obj.add_proj(scene.get_object(object))
                    mouse_button_click = False # on a gere ce click, on veux rester ds ce mode
                    break # ca sert a rien de tester les autres
                elif edit == 'del':
                    selected_edition_obj.del_proj(scene.get_object(object))
                    mouse_button_click = False # on a gere ce click, on veux rester ce ce mode
                    break # ca sert a rien de tester les autres
                else: # on est pas en mode ajout de proj ds un groupe, alors on selectione le proj
                    selected_edition = i
                    selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
                        # en bonus, on le deplace si en mode edition
                    pygame.mouse.get_rel() # initialise la position du curseur
                    edit = 'pos'
                    break
            i += 1
#        if edit == 'add' or edit == 'del': # on a rien trouve a ajouter
#            edit = 'null'
#            print 'null'
# on n'a pas besion de ca, car reset du mode se fait qq soit la position du click
#----------------------------------------------
# on clique sur le  Plan de Feu en mode jeu : on selectionne un objet si il est sous la sourie
    if mouse_button_click and X > taille_menu and  Mode == 'Jeu':
        X_pdf = X-taille_menu # pos de la sourie ds les coordonees du PdF
        X_pdf /= 1.-taille_menu
        X_pdf *= scene.get_taille()
        Y_pdf = Y
        Y_pdf /= (1.-taille_menu)
        Y_pdf *= scene.get_taille()
        i=0
        for object in scene.get_interact_object_list():
            obj = scene.get_object(object).position
            obj_X = obj[0]
            obj_Y = obj[1]
            if X_pdf > (obj_X - 15) and X_pdf < (obj_X + 15) and Y_pdf > (obj_Y - 15) and Y_pdf < (obj_Y + 15):
                if edit == 'sel_fader':
                    print 'control de l\'element ' + str(i) + ' avec le fader ' + str(num_fader)
                    selected_jeu = i
                    selected_jeu_obj = scene.get_object(scene.get_interact_object_list()[selected_jeu])
                    # ajout de l'element i au fader, et increment du fader
                    BCF.myfader.fader[num_fader].set_object(selected_jeu_obj)
                    num_fader += 1
                    if num_fader == 8 or num_fader >= 16:
                        edit = 'null'
                    mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
                    break
                else: # tout les autres mode, on passe en control de projecteur
                    print 'selection du proj ' + str(i)
                    selected_jeu = i
                    selected_jeu_obj = scene.get_object(scene.get_interact_object_list()[selected_jeu])
                    pygame.mouse.get_rel() # initialise la position du curseur
                    edit = 'Control'
                    mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
                    break
            i += 1
# draw the sceen
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
# ---------------------------------------------
# draw Plan de Feu
    glLoadIdentity()
    glTranslatef(taille_menu,0.,0.)
    glScalef(1.-taille_menu,1.-taille_menu,1.)
    glScalef(1./scene.get_taille(),1./scene.get_taille(),1.)
    glPushMatrix()
    
    for Id in scene.get_rectangle_list():
        glPopMatrix()
        glPushMatrix()
        draw.draw_object(scene.scene[Id])
    for Id in scene.get_projecteur_list():
        glPopMatrix()
        glPushMatrix()
        draw.draw_projecteur(scene.scene[Id])
        if Mode == 'Jeu':
            draw.draw_fader(10, 20, scene.scene[Id].get_value()/100.)
        if Mode == 'Edition':
            glScale(2,1,1)
            draw.draw_1_texture([-8,-15], 30, draw.texture_edition_nombres[scene.scene[Id].num_proj])
            glScale(0.5,1,1)
    for Id in scene.get_groupe_list():
        glPopMatrix()
        glPushMatrix()
        draw.draw_groupe(scene.scene[Id])
    for Id in scene.get_effect_list():
        glPopMatrix()
        glPushMatrix()
        draw.draw_effect(scene.scene[Id])
        if Mode == 'Jeu':
            draw.draw_fader(15, 15, scene.scene[Id].get_value()/100.)
        if Mode == 'Edition':
            glScale(2,1,1)
            draw.draw_1_texture([-8,-15], 30, draw.texture_edition_nombres[scene.scene[Id].effect_num])
            glScale(0.5,1,1)



    glPopMatrix()
# ---------------------------------------------
    if True: # elements fixe du menu qq soit le mode
        # draw menu background
        glLoadIdentity()
        glColor4f(0.1,0.1,0.1,1)
        draw.draw_rectangle(taille_menu, 1)

        # draw mode menu choix du mode et interagit avec
        glLoadIdentity()
        glColor4f(1,0,0,1)
        draw.draw_rectangle(taille_menu/6.,0.03)
        if mouse_button_click and test_mouse.pos_size(X,Y,[0,0],taille_menu/6.,0.03):
            print 'mode DMX'
            Mode = 'DMX'
            
        glColor4f(1,1,0,1)
        glTranslate(taille_menu/6.,0,0)
        draw.draw_rectangle(taille_menu/6.,0.03)
        if mouse_button_click and test_mouse.pos_size(X,Y,[taille_menu/6.,0],taille_menu/6.,0.03):
            print 'mode Edition'
            Mode = 'Edition'
            edit = 'null'
            mouse_button_click = False # on a gere ce click, pas besion de tester autre choses


        glColor4f(0,1,0,1)
        glTranslate(taille_menu/6.,0,0)
        draw.draw_rectangle(taille_menu/6.,0.03)
        if mouse_button_click and test_mouse.pos_size(X,Y,[2*taille_menu/6.,0],taille_menu/6.,0.03):
            print 'mode Jeu'
            Mode = 'Jeu'
            edit = 'null'
            mouse_button_click = False # on a gere ce click, pas besion de tester autre choses

        glColor4f(0,1,1,1)
        glTranslate(taille_menu/6.,0,0)
        draw.draw_rectangle(taille_menu/6.,0.03)
        if mouse_button_click and test_mouse.pos_size(X,Y,[3*taille_menu/6.,0],taille_menu/6.,0.03):
            print 'mode Effets'
            Mode = 'Effect'
            edit = 'null'
            mouse_button_click = False # on a gere ce click, pas besion de tester autre choses

        glColor4f(0,0,1,1)
        glTranslate(taille_menu/6.,0,0)
        draw.draw_rectangle(taille_menu/6.,0.03)
        if mouse_button_click and test_mouse.pos_size(X,Y,[4*taille_menu/6.,0],taille_menu/6.,0.03):
            print 'mode Memoires'
            Mode = 'Memory'
            edit = 'null'
            mouse_button_click = False # on a gere ce click, pas besion de tester autre choses

        glColor4f(1,0,1,1)
        glTranslate(taille_menu/6.,0,0)
        draw.draw_rectangle(taille_menu/6.,0.03)
        if mouse_button_click and test_mouse.pos_size(X,Y,[5*taille_menu/6.,0],taille_menu/6.,0.03):
            print 'mode Restitution'
            Mode = 'Restitution'
            edit = 'null'
            mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
            
        # ---------------------------------------------
        # draw mode
        glLoadIdentity()
        glTranslate(0.,0.055,0)
        draw.drawText(str(Mode),30)

# draw menu edition
    if Mode == 'Edition':
    # draw projector and add 1 if clicked
        glLoadIdentity()
        pos = [0.01,0.07]
        i = 0
        for texture in draw.texture_edition_proj:
            draw.draw_1_texture(pos,0.028,texture)
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                proj = Scenes.Projecteur(0)
                proj.proj_type = i
                scene.add_object(proj)
                selected_edition = len(scene.get_graphical_object_list())-1 # on selectionne le dernier object insere
                selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
                edit = 'null'
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
            pos[0] += 0.03
            i += 1
        ## TODO : afficher un + sous la sourie lorsque on passe dessus
        
    # draw groupes and add 1 if clicked
        glLoadIdentity()
        pos = [0.01,0.1]
        i = 0
        for texture in draw.texture_edition_groupe:
            draw.draw_1_texture(pos,0.028,texture)
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                groupe = Scenes.Groupe()
                groupe.groupe_type = i
                groupe.list_proj = dict() # ??? je comprend pas pq cela est necessaire ici
                    # il devrait etre initialise comme ca a sa creation...
                scene.add_object(groupe)
                selected_edition = len(scene.get_graphical_object_list())-1 # on selectionne le dernier object insere
                selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
                edit = 'null'
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
            pos[0] += 0.03
            i += 1
    # draw effect and add 1 if clicked
        glLoadIdentity()
        pos = [0.01,0.13]
        i = 0
        for texture in draw.texture_edition_effect:
            draw.draw_1_texture(pos,0.028,texture)
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                effect = Scenes.Effect(0)
                effect.effect_type = i
                scene.add_object(effect)
                selected_edition = len(scene.get_graphical_object_list())-1 # on selectionne le dernier object insere
                selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
                edit = 'null'
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
            pos[0] += 0.03
            i += 1
            
    # draw geometric objects
        glLoadIdentity()
        pos = [0.01,0.16]
        i = 0
        draw.draw_1_texture(pos,0.028,draw.texture_edition_shape[0])
        if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
            rect = Scenes.Rectangle()
            rect.rectangle_type = 0
            scene.add_object(rect)
            selected_edition = len(scene.get_graphical_object_list())-1 # on selectionne le dernier object insere
            selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
            edit = 'null'
            mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
        pos[0] += 0.03
        draw.draw_1_texture(pos,0.028,draw.texture_edition_shape[1])
        if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
            rect = Scenes.Rectangle()
            rect.rectangle_type = 1
            scene.add_object(rect)
            selected_edition = len(scene.get_graphical_object_list())-1 # on selectionne le dernier object insere
            selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
            edit = 'null'
            mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
        pos[0] += 0.03
        draw.draw_1_texture(pos,0.028,draw.texture_edition_shape[2])
        if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
            rect = Scenes.Rectangle()
            rect.rectangle_type = 2
            scene.add_object(rect)
            selected_edition = len(scene.get_graphical_object_list())-1 # on selectionne le dernier object insere
            selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
            edit = 'null'
            mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
        pos[0] += 0.03
        draw.draw_1_texture(pos,0.028,draw.texture_edition_shape[3])
        if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
            rect = Scenes.Rectangle()
            rect.rectangle_type = 3
            scene.add_object(rect)
            selected_edition = len(scene.get_graphical_object_list())-1 # on selectionne le dernier object insere
            selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
            edit = 'null'
            mouse_button_click = False # on a gere ce click, pas besion de tester autre choses

    # draw property and change if clicked
        glLoadIdentity()
        pos = [0.01,0.19]
        i = 0
        for texture in draw.texture_edition_property:
            draw.draw_1_texture(pos,0.028,texture)
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                if   i == 0:
                    print 'edit red'
                    pygame.mouse.get_rel() # initialise la position du curseur
                    edit = 'red'
                elif i == 1:
                    print 'edit green'
                    pygame.mouse.get_rel() # initialise la position du curseur
                    edit = 'green'
                elif i == 2:
                    print 'edit blue'
                    pygame.mouse.get_rel() # initialise la position du curseur
                    edit = 'blue'
                elif i == 3:
                    print 'edit pos'
                    pygame.mouse.get_rel() # initialise la position du curseur
                    edit = 'pos'
                elif i == 4:
                    print 'edit rot'
                    pygame.mouse.get_rel() # initialise la position du curseur
                    edit = 'rot'
                elif i == 5:
                    print 'delete selected element'
                    if selected_edition_obj == selected_jeu_obj:
                        selected_jeu = 0
                        selected_jeu_obj = scene.get_object(scene.get_interact_object_list()[selected_jeu])
                        # on reset la selection du mode jeu si on doit suprimer son projecteur
                        # !!!!
                    for groupe_id in scene.get_groupe_list():
                        groupe = scene.get_object(groupe_id)
                        for proj_id in groupe.get_proj_list():
                            proj = groupe.get_proj(proj_id)
                            if proj == selected_edition_obj: # l obj a suprimer est utilise par un goupe...
                                groupe.del_proj_id(proj_id)
                                print 'delet element d\' un groupe'
                                break # on a suprime le proj du group, on passe au groupe suivant
                    for tested_fader in BCF.myfader.list():
                        if BCF.myfader.fader[tested_fader].pointeur_vers_obj == selected_edition_obj:
                            BCF.myfader.fader[tested_fader].set_object(0)
                            print 'delet element d\' un fader'
                    if scene.get_interact_object_list_size() > 1 or isinstance(selected_edition_obj,Scenes.Rectangle):
                        if selected_edition_obj == selected_jeu_obj: # on suprime l obj qui est selectionne en mode jeu
                            deleted_jeu = True
                        else:
                            deleted_jeu = False
                        scene.del_graphical_object(selected_edition)
                        selected_edition = 0
                        selected_edition_obj = scene.get_object(scene.get_graphical_object_list()[selected_edition])
                        if deleted_jeu :
                            selected_jeu = 0
                            selected_jeu_obj = scene.get_object(scene.get_interact_object_list()[selected_jeu])
                    edit = 'null'
                ## TODO : afficher un truc sur la sourie pour indiquer qu'il faut la bouger
                else :
                    # ??? on devrais pas etre la
                    edit = 'null'
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
            pos[0] += 0.03
            i += 1
    # menu dependant de l'objet selectionne
        pos = [0.01,0.22]
        if isinstance (selected_edition_obj, Scenes.Projecteur):
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[0])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                selected_edition_obj.change_proj_type()
                edit = 'null' # ca doit rien changer en general
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
            pos[1] += 0.03
            glPushMatrix()
            glTranslate(pos[0],pos[1],0) # c'est un peu degeu, mais j'avais qu'a mieu definir mes fct avant...
            glScale(2,1,1)
            draw.draw_1_texture((0,0),0.028,draw.texture_edition_nombres[int(selected_edition_obj.num_proj)])
            glPopMatrix()
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.056,0.028):
                print 'edit num du potentiomettre'
                pygame.mouse.get_rel() # initialise la position du curseur
                edit = 'num_proj'
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
                ## TODO : menu pour editer la sortie DMX
        if isinstance (selected_edition_obj, Scenes.Groupe):
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[0])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                selected_edition_obj.change_groupe_type()
                edit = 'null'
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
            pos[0] += 0.03
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[3])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                edit = 'add'
                mouse_button_click = False # on a gere ce click, on le suprime
                print 'add'
            pos[0] += 0.03
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[4])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                edit = 'del'
                mouse_button_click = False # on a gere ce click, on le suprime
        if isinstance (selected_edition_obj, Scenes.Effect):
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[0])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                selected_edition_obj.change_effect_type()
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
                edit = 'null'
            pos[1] += 0.03
            glPushMatrix()
            glTranslate(pos[0],pos[1],0) # c'est un peu degeu, mais j'avais qu'a mieu definir mes fct avant...
            glScale(2,1,1)
            draw.draw_1_texture((0,0),0.028,draw.texture_edition_nombres[int(selected_edition_obj.effect_num)])
            glPopMatrix()
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.056,0.028):
                print 'edit num de l\'effet'
                pygame.mouse.get_rel() # initialise la position du curseur
                edit = 'num_effect'
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
        if isinstance (selected_edition_obj, Scenes.Rectangle):
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[0])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                selected_edition_obj.change_rectangle_type()
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses
                edit = 'null'
            pos[0] += 0.03
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[1])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                pygame.mouse.get_rel() # initialise la position du curseur
                edit = 'alpha'
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses           
            pos[0] += 0.03
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[2])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                pygame.mouse.get_rel() # initialise la position du curseur
                edit = 'resize'
                mouse_button_click = False # on a gere ce click, pas besion de tester autre choses

    # draw selected object
        glLoadIdentity()
        glTranslatef(taille_menu,0.,0.)
        glScalef(1.-taille_menu,1.-taille_menu,1.)
        glScalef(1./scene.get_taille(),1./scene.get_taille(),1.)
        pos = selected_edition_obj.position
        glTranslatef(pos[0],pos[1], 0.)
        draw.draw_circle(20)
        
    # draw selected projectors from groupe
        if isinstance(selected_edition_obj,Scenes.Groupe):
            glLoadIdentity()
            glTranslatef(taille_menu,0.,0.)
            glScalef(1.-taille_menu,1.-taille_menu,1.)
            glScalef(1./scene.get_taille(),1./scene.get_taille(),1.)
            glColor(1,0,0,1)
            glPushMatrix()
            for obj in selected_edition_obj.get_proj_list():
                glPopMatrix()
                glPushMatrix()
                pos = selected_edition_obj.get_proj(obj).position
                glTranslatef(pos[0],pos[1], 0.)
                draw.draw_circle(10)
            glPopMatrix()
# ---------------------------------------------
# menu jeu
    if Mode == 'Jeu':
        pos=[0.023,0.2]
        for i in range(8) : # 8 premier potentiomettres (9 a 16)
            glLoadIdentity()
            glTranslate(pos[0],pos[1],0)
            draw.draw_fader(0.01,0.04,BCF.myfader.fader[i+8].get_value()/100.)
            if mouse_button_click and test_mouse.pos_size_center(X,Y,pos,0.01,0.04):
                mouse_button_click = False
                print 'mvt fader : ' + str(i+8)   
                pygame.mouse.get_rel()
                edit = 'mvt_fader'
                num_fader = i+8
            pos[0] +=0.022
        
        pos=[0.023,0.4]
        for i in range(8) : # 8 potentiomettres lineaire (1 a 8)
            glLoadIdentity()
            glTranslate(pos[0],pos[1],0)
            draw.draw_fader(0.01,0.07,BCF.myfader.fader[i].get_value()/100.)
            if mouse_button_click and test_mouse.pos_size_center(X,Y,pos,0.01,0.07):
                mouse_button_click = False
                print 'mvt fader : ' + str(i)
                pygame.mouse.get_rel()
                edit = 'mvt_fader'
                num_fader = i
            pos[0] +=0.022

        glLoadIdentity()
        pos=[0.009,0.24]
        for i in range(8) : # dessin des bouton de selection de projecteur
            texture_red = 5
            if edit == 'sel_fader' and num_fader == i+8:
                texture_red = 6
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[texture_red])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                mouse_button_click = False
                print 'selection du fader : ' + str(i+8)
                edit = 'sel_fader'
                num_fader = i+8
            pos[0] += 0.022
            
        glLoadIdentity()
        pos=[0.009,0.47]
        for i in range(8) : # dessin des bouton de selection de projecteur
            texture_red = 5
            if edit == 'sel_fader' and num_fader == i:
                texture_red = 6
            draw.draw_1_texture(pos,0.028,draw.texture_edition_diver[texture_red])
            if mouse_button_click and test_mouse.pos_size(X,Y,pos,0.028,0.028):
                mouse_button_click = False
                print 'selection du fader : ' + str(i)
                edit = 'sel_fader'
                num_fader = i
            pos[0] += 0.022
  
# selection en mode jeu
    if Mode == 'Jeu':
      # draw selected object
        glColor4f(1,1,1,1)
        glLoadIdentity()
        glTranslatef(taille_menu,0.,0.)
        glScalef(1.-taille_menu,1.-taille_menu,1.)
        glScalef(1./scene.get_taille(),1./scene.get_taille(),1.)
        pos = selected_jeu_obj.position
        glTranslatef(pos[0],pos[1], 0.)
        draw.draw_circle(20)
        
# dessine le curseur
    # draw.draw_cursor(X,Y)
    if edit == 'sel_fader':
        glColor4f(1.,1.,1.,1.)
        glLoadIdentity()
        glTranslatef(X,Y,0.0)
        glTranslatef(-0.02,-0.02,0)
        draw.draw_1_texture((0,0),0.02,draw.texture_edition_diver[3])
    if edit == 'add':
        glColor4f(1.,1.,1.,1.)
        glLoadIdentity()
        glTranslatef(X,Y,0.0)
        glTranslatef(-0.02,-0.02,0)
        draw.draw_1_texture((0,0),0.02,draw.texture_edition_diver[3])
    if edit == 'del':
        glColor4f(1.,1.,1.,1.)
        glLoadIdentity()
        glTranslatef(X,Y,0.0)
        glTranslatef(-0.02,-0.02,0)
        draw.draw_1_texture((0,0),0.02,draw.texture_edition_diver[4])

# ---------------------------------------------
# end of drawing
    pygame.display.flip()
# ---------------------------------------------
# fin de la boucle TR

## TODO mv le fichier scene.txt actuel en fichier de sauvegarde
load_save.save(scene,nom_save)
# on ferme tout
Pd.mypdconnection.close()
Pd.pdconnected.close()

print "bye bye..."
exit()
